/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;

public class MatrixView
extends AbstractMatrix {
    private Matrix matrix;
    private int[] offset;
    private int[] cardinality;

    public MatrixView() {
    }

    public MatrixView(Matrix matrix, int[] offset, int[] cardinality) {
        this.matrix = matrix;
        this.offset = offset;
        this.cardinality = cardinality;
    }

    public int[] size() {
        return this.cardinality;
    }

    public Matrix clone() {
        MatrixView clone = (MatrixView)super.clone();
        clone.matrix = this.matrix.clone();
        clone.offset = (int[])this.offset.clone();
        clone.cardinality = (int[])this.cardinality.clone();
        return clone;
    }

    public double getQuick(int row, int column) {
        return this.matrix.getQuick(this.offset[0] + row, this.offset[1] + column);
    }

    public Matrix like() {
        return this.matrix.like(this.cardinality[0], this.cardinality[1]);
    }

    public Matrix like(int rows, int columns) {
        return this.matrix.like(rows, columns);
    }

    public void setQuick(int row, int column, double value) {
        this.matrix.setQuick(this.offset[0] + row, this.offset[1] + column, value);
    }

    public int[] getNumNondefaultElements() {
        return this.cardinality;
    }

    public Matrix viewPart(int[] offset, int[] size) {
        if (size[0] > this.cardinality[0] || size[1] > this.cardinality[1]) {
            throw new CardinalityException();
        }
        if (offset[0] < 0 || offset[0] + size[0] > this.cardinality[0] || offset[1] < 0 || offset[1] + size[1] > this.cardinality[1]) {
            throw new IndexException();
        }
        int[] origin = (int[])offset.clone();
        origin[0] = origin[0] + offset[0];
        origin[1] = origin[1] + offset[1];
        return new MatrixView(this.matrix, origin, size);
    }

    public Matrix assignColumn(int column, Vector other) {
        if (this.cardinality[0] != other.size()) {
            throw new CardinalityException();
        }
        for (int row = 0; row < this.cardinality[0]; ++row) {
            this.matrix.setQuick(row + this.offset[0], column + this.offset[1], other.getQuick(row));
        }
        return this;
    }

    public Matrix assignRow(int row, Vector other) {
        if (this.cardinality[1] != other.size()) {
            throw new CardinalityException();
        }
        for (int col = 0; col < this.cardinality[1]; ++col) {
            this.matrix.setQuick(row + this.offset[0], col + this.offset[1], other.getQuick(col));
        }
        return this;
    }

    public Vector getColumn(int column) {
        if (column < 0 || column >= this.cardinality[1]) {
            throw new IndexException();
        }
        return new VectorView(this.matrix.getColumn(column + this.offset[1]), this.offset[0], this.cardinality[0]);
    }

    public Vector getRow(int row) {
        if (row < 0 || row >= this.cardinality[0]) {
            throw new IndexException();
        }
        return new VectorView(this.matrix.getRow(row + this.offset[0]), this.offset[1], this.cardinality[1]);
    }
}

