/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.mahout.math.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonVectorAdapter
implements JsonSerializer<Vector>,
JsonDeserializer<Vector> {
    private static final Logger log = LoggerFactory.getLogger(JsonVectorAdapter.class);
    public static final String VECTOR = "vector";

    public JsonElement serialize(Vector src, Type typeOfSrc, JsonSerializationContext context) {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Vector.class, (Object)new JsonVectorAdapter());
        Gson gson = builder.create();
        JsonObject obj = new JsonObject();
        obj.add("class", (JsonElement)new JsonPrimitive(src.getClass().getName()));
        obj.add(VECTOR, (JsonElement)new JsonPrimitive(gson.toJson((Object)src)));
        return obj;
    }

    public Vector deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Vector.class, (Object)new JsonVectorAdapter());
        Gson gson = builder.create();
        JsonObject obj = json.getAsJsonObject();
        String klass = obj.get("class").getAsString();
        String vector = obj.get(VECTOR).getAsString();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Class<?> cl = null;
        try {
            cl = ccl.loadClass(klass);
        }
        catch (ClassNotFoundException e) {
            log.warn("Error while loading class", (Throwable)e);
        }
        return (Vector)gson.fromJson(vector, cl);
    }
}

