/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.solr.schema.SortableFloatFieldSource;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.FieldCacheSource;
import org.apache.solr.search.function.StringIndexDocValues;

public class StrFieldSource
extends FieldCacheSource {
    private static int hcode = SortableFloatFieldSource.class.hashCode();

    public StrFieldSource(String field) {
        super(field);
    }

    public String description() {
        return "str(" + this.field + ')';
    }

    public DocValues getValues(Map context, IndexReader reader) throws IOException {
        return new StringIndexDocValues(this, reader, this.field){

            protected String toTerm(String readableValue) {
                return readableValue;
            }

            public float floatVal(int doc) {
                return this.intVal(doc);
            }

            public int intVal(int doc) {
                int ord = this.order[doc];
                return ord;
            }

            public long longVal(int doc) {
                return this.intVal(doc);
            }

            public double doubleVal(int doc) {
                return this.intVal(doc);
            }

            public String strVal(int doc) {
                int ord = this.order[doc];
                return this.lookup[ord];
            }

            public String toString(int doc) {
                return StrFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        return o instanceof StrFieldSource && super.equals(o);
    }

    public int hashCode() {
        return hcode + super.hashCode();
    }
}

