/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.NameClassPair;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationParameterSettings_impl
extends MetaDataObject_impl
implements ConfigurationParameterSettings {
    static final long serialVersionUID = 3476535733588304983L;
    private NameValuePair[] mParameterSettings = new NameValuePair[0];
    private Map<String, NameValuePair[]> mSettingsForGroups = new HashMap<String, NameValuePair[]>();
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("configurationParameterSettings", new PropertyXmlInfo[]{new PropertyXmlInfo("parameterSettings", null), new PropertyXmlInfo("settingsForGroups", null)});

    @Override
    public NameValuePair[] getParameterSettings() {
        return this.mParameterSettings;
    }

    @Override
    public void setParameterSettings(NameValuePair[] aSettings) {
        if (aSettings == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aSettings", "setParameterSettings"});
        }
        this.mParameterSettings = aSettings;
    }

    @Override
    public Map<String, NameValuePair[]> getSettingsForGroups() {
        return this.mSettingsForGroups;
    }

    @Override
    public Object getParameterValue(String aParamName) {
        NameValuePair[] nvps = this.getParameterSettings();
        if (nvps != null) {
            for (int i = 0; i < nvps.length; ++i) {
                if (!aParamName.equals(nvps[i].getName())) continue;
                return nvps[i].getValue();
            }
        }
        return null;
    }

    @Override
    public Object getParameterValue(String aGroupName, String aParamName) {
        if (aGroupName == null) {
            return this.getParameterValue(aParamName);
        }
        NameValuePair[] nvps = this.mSettingsForGroups.get(aGroupName);
        if (nvps != null) {
            for (int i = 0; i < nvps.length; ++i) {
                if (!aParamName.equals(nvps[i].getName())) continue;
                return nvps[i].getValue();
            }
        }
        return null;
    }

    @Override
    public void setParameterValue(String aParamName, Object aValue) {
        if (aValue != null) {
            NameValuePair[] nvps = this.getParameterSettings();
            if (nvps != null) {
                for (int i = 0; i < nvps.length; ++i) {
                    if (!aParamName.equals(nvps[i].getName())) continue;
                    nvps[i].setValue(aValue);
                    return;
                }
                NameValuePair_impl newNVP = new NameValuePair_impl(aParamName, aValue);
                NameValuePair[] newArr = new NameValuePair[nvps.length + 1];
                System.arraycopy(nvps, 0, newArr, 0, nvps.length);
                newArr[newArr.length - 1] = newNVP;
                this.setParameterSettings(newArr);
            } else {
                this.setParameterSettings(new NameValuePair[]{new NameValuePair_impl(aParamName, aValue)});
            }
        } else {
            NameValuePair[] nvps = this.getParameterSettings();
            if (nvps != null) {
                for (int i = 0; i < nvps.length; ++i) {
                    if (!aParamName.equals(nvps[i].getName())) continue;
                    NameValuePair[] newArr = new NameValuePair[nvps.length - 1];
                    System.arraycopy(nvps, 0, newArr, 0, i);
                    System.arraycopy(nvps, i + 1, newArr, i, nvps.length - i - 1);
                    this.setParameterSettings(newArr);
                    break;
                }
            }
        }
    }

    @Override
    public void setParameterValue(String aGroupName, String aParamName, Object aValue) {
        if (aGroupName == null) {
            this.setParameterValue(aParamName, aValue);
        } else if (aValue != null) {
            NameValuePair[] nvps = this.mSettingsForGroups.get(aGroupName);
            if (nvps == null) {
                NameValuePair_impl newNVP = new NameValuePair_impl(aParamName, aValue);
                this.mSettingsForGroups.put(aGroupName, new NameValuePair[]{newNVP});
            } else {
                for (int i = 0; i < nvps.length; ++i) {
                    if (!aParamName.equals(nvps[i].getName())) continue;
                    nvps[i].setValue(aValue);
                    return;
                }
                NameValuePair_impl newNVP = new NameValuePair_impl(aParamName, aValue);
                NameValuePair[] newArr = new NameValuePair[nvps.length + 1];
                System.arraycopy(nvps, 0, newArr, 0, nvps.length);
                newArr[newArr.length - 1] = newNVP;
                this.mSettingsForGroups.put(aGroupName, newArr);
            }
        } else {
            NameValuePair[] nvps = this.mSettingsForGroups.get(aGroupName);
            if (nvps != null) {
                for (int i = 0; i < nvps.length; ++i) {
                    if (!aParamName.equals(nvps[i].getName())) continue;
                    NameValuePair[] newArr = new NameValuePair[nvps.length - 1];
                    System.arraycopy(nvps, 0, newArr, 0, i);
                    System.arraycopy(nvps, i + 1, newArr, i, nvps.length - i - 1);
                    this.mSettingsForGroups.put(aGroupName, newArr);
                    break;
                }
            }
        }
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    @Override
    public List<NameClassPair> listAttributes() {
        List<NameClassPair> result = super.listAttributes();
        result.add(new NameClassPair("settingsForGroups", Map.class.getName()));
        return result;
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        ArrayList<XMLizable> nvps = new ArrayList<XMLizable>();
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("nameValuePair".equals(elem.getTagName())) {
                nvps.add(aParser.buildObject(elem, aOptions));
                continue;
            }
            if ("settingsForGroup".equals(elem.getTagName())) {
                String key = elem.getAttribute("name");
                ArrayList<XMLizable> vals = new ArrayList<XMLizable>();
                NodeList arrayNodes = elem.getChildNodes();
                for (int j = 0; j < arrayNodes.getLength(); ++j) {
                    Node curArrayNode = arrayNodes.item(j);
                    if (!(curArrayNode instanceof Element)) continue;
                    Element valElem = (Element)curArrayNode;
                    vals.add(aParser.buildObject(valElem));
                }
                if (vals.isEmpty()) continue;
                NameValuePair[] valArr = new NameValuePair[vals.size()];
                vals.toArray(valArr);
                this.mSettingsForGroups.put(key, valArr);
                continue;
            }
            throw new InvalidXMLException("unknown_element", new Object[]{elem.getTagName()});
        }
        NameValuePair[] nvpArr = new NameValuePair[nvps.size()];
        nvps.toArray(nvpArr);
        this.setParameterSettings(nvpArr);
    }

    @Override
    protected void writePropertyAsElement(PropertyXmlInfo aPropInfo, String aNamespace, ContentHandler aContentHandler) throws SAXException {
        if ("settingsForGroups".equals(aPropInfo.propertyName)) {
            this.writeMapPropertyToXml("settingsForGroups", null, "name", "settingsForGroup", true, aNamespace, aContentHandler);
        } else {
            super.writePropertyAsElement(aPropInfo, aNamespace, aContentHandler);
        }
    }
}

