/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.alchemy.annotator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang.Validate;
import org.apache.uima.UimaContext;
import org.apache.uima.alchemy.annotator.exception.AlchemyCallFailedException;
import org.apache.uima.alchemy.digester.DigesterProvider;
import org.apache.uima.alchemy.digester.OutputDigester;
import org.apache.uima.alchemy.digester.domain.Results;
import org.apache.uima.alchemy.digester.exception.ResultDigestingException;
import org.apache.uima.alchemy.digester.exception.UnsupportedResultFormatException;
import org.apache.uima.alchemy.mapper.Alchemy2TypeSystemMapper;
import org.apache.uima.alchemy.mapper.exception.MappingException;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public abstract class AbstractAlchemyAnnotator
extends JCasAnnotator_ImplBase {
    private static final String STATUS_OK = "OK";
    private URL alchemyService;
    protected String serviceParams;
    private final String[] charsToReplace = new String[]{"<", ">", "\"", "'", "&"};
    private OutputDigester digester;
    private DigesterProvider digesterProvider;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.digesterProvider = this.createDigester();
        try {
            Object configParameterValue = aContext.getConfigParameterValue("outputMode");
            this.digester = this.digesterProvider.getDigester(String.valueOf(configParameterValue));
        }
        catch (UnsupportedResultFormatException e1) {
            throw new ResourceInitializationException((Throwable)e1);
        }
        try {
            this.alchemyService = this.createServiceURI();
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        StringBuffer serviceParamsBuf = new StringBuffer();
        serviceParamsBuf.append("&apikey=");
        serviceParamsBuf.append(aContext.getConfigParameterValue("apikey"));
        for (String param : this.getServiceParameters()) {
            serviceParamsBuf.append("&").append(param).append("=");
            serviceParamsBuf.append(aContext.getConfigParameterValue(param));
        }
        this.serviceParams = serviceParamsBuf.toString();
    }

    protected String cleanText(JCas aJCas) {
        String modifiedText = aJCas.getDocumentText();
        for (int i = 0; i < this.charsToReplace.length; ++i) {
            modifiedText = modifiedText.replaceAll(this.charsToReplace[i], "");
        }
        modifiedText = modifiedText.replaceAll("\n", " ");
        modifiedText = modifiedText.replaceAll("\r", " ");
        return modifiedText;
    }

    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        block14: {
            this.initializeRuntimeParameters(aJCas);
            URLConnection connection = null;
            try {
                connection = this.alchemyService.openConnection();
                if (connection instanceof HttpURLConnection) {
                    connection.setDoOutput(true);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), "UTF-8"));
                    writer.write(this.serviceParams);
                    writer.flush();
                    writer.close();
                }
                connection.connect();
                InputStream bufByteIn = this.parseOutput(connection);
                try {
                    Results results = this.digester.parseAlchemyXML(bufByteIn);
                    Validate.notNull((Object)results);
                    Validate.notNull((Object)results.getStatus());
                    if (this.getContext().getLogger().isLoggable(Level.FINER)) {
                        this.getContext().getLogger().log(Level.FINER, results.toString());
                    }
                    if (results.getStatus().equalsIgnoreCase(STATUS_OK)) {
                        this.mapResultsToTypeSystem(results, aJCas);
                        break block14;
                    }
                    throw new AlchemyCallFailedException(results.getStatus() + " - " + results.getStatusInfo());
                }
                catch (Exception e) {
                    throw new ResultDigestingException(e);
                }
                finally {
                    bufByteIn.close();
                }
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            finally {
                if (connection != null && connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
            }
        }
    }

    private InputStream parseOutput(URLConnection connection) throws IOException {
        return new BufferedInputStream(connection.getInputStream());
    }

    private void mapResultsToTypeSystem(Results results, JCas aJCas) throws MappingException {
        Alchemy2TypeSystemMapper.mapResultsToTypeSystem(results, aJCas);
    }

    public void setDigesterProvider(DigesterProvider digesterProvider) {
        this.digesterProvider = digesterProvider;
    }

    public DigesterProvider getDigesterProvider() {
        return this.digesterProvider;
    }

    protected abstract DigesterProvider createDigester();

    protected abstract URL createServiceURI() throws MalformedURLException;

    protected abstract String[] getServiceParameters();

    protected abstract void initializeRuntimeParameters(JCas var1) throws AnalysisEngineProcessException;
}

