/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.tagger;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.examples.tagger.NGram;
import org.apache.uima.examples.tagger.trainAndTest.ModelGeneration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Viterbi {
    public static Map<String, List> init_probs(Map<String, Double> pos_s) {
        HashMap<String, List> init_probs = new HashMap<String, List>();
        double p_init = Math.log(1.0);
        Iterator<Map.Entry<String, Double>> a_pos = pos_s.entrySet().iterator();
        for (int h = 0; h < pos_s.size(); ++h) {
            Map.Entry<String, Double> entry_init = a_pos.next();
            String key_init = entry_init.getKey();
            Double value_init = entry_init.getValue();
            Double p_local = p_init;
            ArrayList<String> vpath_list = new ArrayList<String>();
            ArrayList<Serializable> init_list = new ArrayList<Serializable>(3);
            vpath_list.add(key_init);
            double p = p_local + Math.log(value_init);
            init_list.add(Double.valueOf(p));
            init_list.add(vpath_list);
            init_list.add(Double.valueOf(p));
            init_probs.put(key_init, init_list);
        }
        return init_probs;
    }

    public static List process(int N, List<String> sentence, Map<String, Map<String, Double>> suffix_tree, Map<String, Map<String, Double>> suffix_tree_cap, Map<NGram, Double> transition_probs, Map<String, Map<String, Double>> word_probs, double[] lambdas2, double[] lambdas3, double theta) {
        NGram ngram = null;
        NGram ngram2 = null;
        sentence.add(0, ".");
        HashMap<String, List> all = new HashMap<String, List>();
        for (int i = 0; i < sentence.size() - 1; ++i) {
            String token;
            Map<Object, Object> available_pos = new HashMap();
            if (i == 0) {
                token = sentence.get(1);
                String non_cap = token.toLowerCase();
                if (word_probs.containsKey(token) || word_probs.containsKey(non_cap)) {
                    available_pos = word_probs.containsKey(non_cap) ? word_probs.get(non_cap) : word_probs.get(token);
                } else {
                    Map<String, Map<String, Double>> suffix_tree_local = ModelGeneration.capitalized(sentence.get(1)) ? suffix_tree_cap : suffix_tree;
                    char[] unknown = sentence.get(1).toCharArray();
                    for (int j = 0; j < unknown.length; ++j) {
                        String suffix = sentence.get(1).substring(j, unknown.length);
                        if (suffix_tree_local.containsKey(suffix)) {
                            Map<Object, Object> available_pos_zwischen = suffix_tree_local.get(suffix);
                            for (int suf = j + 1; suf < unknown.length; ++suf) {
                                double zwischen_prob;
                                Double value;
                                String subsuffix = sentence.get(1).substring(suf, unknown.length);
                                Map<Object, Object> pos = new HashMap();
                                if (suffix_tree_local.containsKey(subsuffix)) {
                                    pos = suffix_tree_local.get(subsuffix);
                                    for (Map.Entry<Object, Object> entry : pos.entrySet()) {
                                        Object object = entry.getKey();
                                        value = (Double)entry.getValue();
                                        if (!available_pos_zwischen.containsKey(object)) continue;
                                        zwischen_prob = (value + theta * (Double)available_pos_zwischen.get(object)) / (1.0 + theta);
                                        available_pos_zwischen.put(object, zwischen_prob);
                                    }
                                    continue;
                                }
                                for (Map.Entry<String, Double> entry : available_pos_zwischen.entrySet()) {
                                    String string = entry.getKey();
                                    value = entry.getValue();
                                    zwischen_prob = (0.0 + theta * value) / (1.0 + theta);
                                    pos.put(string, zwischen_prob);
                                }
                                available_pos_zwischen = pos;
                            }
                            available_pos = available_pos_zwischen;
                            break;
                        }
                        if (j != unknown.length - 1) continue;
                        if (word_probs.containsKey("(")) {
                            available_pos = word_probs.get("(");
                            continue;
                        }
                        available_pos.put("(", Double.MIN_VALUE);
                    }
                }
                all.putAll(Viterbi.init_probs(available_pos));
                continue;
            }
            token = sentence.get(i);
            HashMap m = new HashMap();
            Map<Object, Object> possible_pos_next = new HashMap();
            if (word_probs.containsKey(sentence.get(i + 1))) {
                possible_pos_next = word_probs.get(sentence.get(i + 1));
            } else {
                Map<String, Map<String, Double>> suffix_tree_local = ModelGeneration.capitalized(sentence.get(i + 1)) ? suffix_tree_cap : suffix_tree;
                char[] unknown = sentence.get(i + 1).toCharArray();
                for (int j = 0; j < unknown.length; ++j) {
                    String suffix = sentence.get(i + 1).substring(j, unknown.length);
                    if (suffix_tree_local.containsKey(suffix)) {
                        Map<Object, Object> available_pos_zwischen = suffix_tree_local.get(suffix);
                        for (int suf = j + 1; suf < unknown.length; ++suf) {
                            double zwischen_prob;
                            Double value;
                            Object key;
                            String subsuffix = sentence.get(i + 1).substring(suf, unknown.length);
                            Map<Object, Object> pos = new HashMap();
                            if (suffix_tree_local.containsKey(subsuffix)) {
                                pos = suffix_tree_local.get(subsuffix);
                                for (Map.Entry<Object, Object> entry : pos.entrySet()) {
                                    key = entry.getKey();
                                    value = (Double)entry.getValue();
                                    if (!available_pos_zwischen.containsKey(key)) continue;
                                    zwischen_prob = (value + theta * (Double)available_pos_zwischen.get(key)) / (1.0 + theta);
                                    available_pos_zwischen.put(key, zwischen_prob);
                                }
                                continue;
                            }
                            for (Map.Entry<String, Double> entry : available_pos_zwischen.entrySet()) {
                                key = entry.getKey();
                                value = entry.getValue();
                                zwischen_prob = (0.0 + theta * value) / (1.0 + theta);
                                pos.put(key, zwischen_prob);
                            }
                            available_pos_zwischen = pos;
                        }
                        possible_pos_next = available_pos_zwischen;
                        break;
                    }
                    if (j != unknown.length - 1) continue;
                    if (possible_pos_next.containsKey("(")) {
                        possible_pos_next = word_probs.get("(");
                        continue;
                    }
                    possible_pos_next.put("(", Double.MIN_VALUE);
                }
            }
            Iterator<Map.Entry<Object, Object>> keyValuePairs_next = possible_pos_next.entrySet().iterator();
            for (int u = 0; u < possible_pos_next.size(); ++u) {
                Map.Entry<Object, Object> entry_next = keyValuePairs_next.next();
                String key_next = (String)entry_next.getKey();
                Double value_next = (Double)entry_next.getValue();
                double total_prob = 0.0;
                ArrayList<String> max_viterbi_path = new ArrayList<String>();
                double d = 0.0;
                Iterator keyValuePairs = all.entrySet().iterator();
                NGram nextNgram = new NGram(key_next);
                double nextNgramTransProb = 0.0;
                if (transition_probs.containsKey(nextNgram)) {
                    nextNgramTransProb = transition_probs.get(nextNgram);
                }
                for (int y = 0; y < all.size(); ++y) {
                    double ppp;
                    double lambda2;
                    double lambda1;
                    Map.Entry entry = keyValuePairs.next();
                    Object key = entry.getKey();
                    List probs = (List)all.get(key);
                    List path_local = (List)probs.get(1);
                    Double vprob_local = (Double)probs.get(2);
                    if (N == 3 && i == 1) {
                        ngram = new NGram((String)path_local.get(path_local.size() - 1), key_next);
                    } else if (N == 2) {
                        ngram = new NGram((String)path_local.get(path_local.size() - 1), key_next);
                    } else if (N == 3 && i != 1) {
                        ngram = new NGram((String)path_local.get(path_local.size() - 2), (String)path_local.get(path_local.size() - 1), key_next);
                        ngram2 = new NGram((String)path_local.get(path_local.size() - 1), key_next);
                    } else {
                        System.err.println("at the moment only bi-and trigramms are supported");
                    }
                    double pp = 0.0;
                    if (N == 3 && i == 1) {
                        lambda1 = lambdas2[0];
                        lambda2 = lambdas2[1];
                        ppp = transition_probs.containsKey(ngram) ? lambda2 * transition_probs.get(ngram) + lambda1 * transition_probs.get(nextNgram) : lambda1 * nextNgramTransProb;
                        pp = Math.log(value_next) + Math.log(ppp);
                    } else if (N == 3) {
                        lambda1 = lambdas3[0];
                        lambda2 = lambdas3[1];
                        double lambda3 = lambdas3[2];
                        if (transition_probs.containsKey(ngram)) {
                            double transProbNgram2 = transition_probs.containsKey(ngram2) ? transition_probs.get(ngram2) : 0.0;
                            ppp = lambda3 * transition_probs.get(ngram) + lambda2 * transProbNgram2 + lambda1 * nextNgramTransProb;
                        } else {
                            ppp = transition_probs.containsKey(ngram2) ? lambda2 * transition_probs.get(ngram2) + lambda1 * nextNgramTransProb : lambda1 * nextNgramTransProb;
                        }
                        pp = Math.log(value_next) + Math.log(ppp);
                    }
                    if (N == 2) {
                        lambda1 = lambdas2[0];
                        lambda2 = lambdas2[1];
                        ppp = transition_probs.containsKey(ngram) ? lambda2 * transition_probs.get(ngram) + lambda1 * transition_probs.get(nextNgram) : lambda1 * transition_probs.get(nextNgram);
                        pp = Math.log(value_next) + Math.log(ppp);
                    }
                    vprob_local = vprob_local + pp;
                    if (y == 0) {
                        d = vprob_local;
                    }
                    if (!(vprob_local >= d)) continue;
                    d = vprob_local;
                    max_viterbi_path = new ArrayList(path_local);
                    max_viterbi_path.add(key_next);
                }
                ArrayList<Serializable> v = new ArrayList<Serializable>(3);
                v.add(Double.valueOf(total_prob));
                v.add(max_viterbi_path);
                v.add(Double.valueOf(d));
                m.put(key_next, v);
            }
            all = m;
        }
        List max_viterbi_path = new ArrayList();
        double max_viterbi_prob = 0.0;
        Iterator keyValuePairs_all = all.entrySet().iterator();
        for (int j = 0; j < all.size(); ++j) {
            Map.Entry entry = keyValuePairs_all.next();
            ArrayList value = (ArrayList)entry.getValue();
            List path_local = (List)value.get(1);
            Double vprob_local = (Double)value.get(2);
            if (j == 0) {
                max_viterbi_prob = vprob_local;
            }
            if (!(vprob_local >= max_viterbi_prob)) continue;
            max_viterbi_path = path_local;
            max_viterbi_prob = vprob_local;
        }
        ArrayList<Serializable> result = new ArrayList<Serializable>(3);
        result.add((Serializable)((Object)max_viterbi_path));
        result.add(Double.valueOf(max_viterbi_prob));
        return max_viterbi_path;
    }
}

