/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.DoubleCharProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractDoubleCharMap
extends AbstractSet {
    public boolean containsKey(final double key) {
        return !this.forEachKey(new DoubleProcedure(){

            public boolean apply(double iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final char value) {
        return !this.forEachPair(new DoubleCharProcedure(){

            public boolean apply(double iterKey, char iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractDoubleCharMap copy() {
        return (AbstractDoubleCharMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDoubleCharMap)) {
            return false;
        }
        final AbstractDoubleCharMap other = (AbstractDoubleCharMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new DoubleCharProcedure(){

            public boolean apply(double key, char value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new DoubleCharProcedure(){

            public boolean apply(double key, char value) {
                return AbstractDoubleCharMap.this.containsKey(key) && AbstractDoubleCharMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public boolean forEachPair(final DoubleCharProcedure procedure) {
        return this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                return procedure.apply(key, AbstractDoubleCharMap.this.get(key));
            }
        });
    }

    public abstract char get(double var1);

    public DoubleArrayList keys() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(DoubleArrayList keyList) {
        this.pairsSortedByValue(keyList, new CharArrayList(this.size()));
    }

    public void pairsMatching(final DoubleCharProcedure condition, final DoubleArrayList keyList, final CharArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new DoubleCharProcedure(){

            public boolean apply(double key, char value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(DoubleArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(DoubleArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final double[] k = keyList.elements();
        final char[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                char t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                double t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(double var1, char var3);

    public abstract boolean removeKey(double var1);

    public String toString() {
        DoubleArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        DoubleArrayList theKeys = new DoubleArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public CharArrayList values() {
        CharArrayList list = new CharArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final CharArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            public boolean apply(double key) {
                list.add(AbstractDoubleCharMap.this.get(key));
                return true;
            }
        });
    }

    public char adjustOrPutValue(double key, char newValue, char incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (char)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

