/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.pool;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.carrot2.util.Pair;
import org.carrot2.util.pool.IActivationListener;
import org.carrot2.util.pool.IDisposalListener;
import org.carrot2.util.pool.IInstantiationListener;
import org.carrot2.util.pool.IParameterizedPool;
import org.carrot2.util.pool.IPassivationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FixedSizePool<T, P>
implements IParameterizedPool<T, P> {
    private Map<Pair<Class<? extends T>, P>, ArrayList<T>> instances = Maps.newHashMap();
    private IInstantiationListener<T, P> instantiationListener;
    private IActivationListener<T, P> activationListener;
    private IPassivationListener<T, P> passivationListener;
    private IDisposalListener<T, P> disposalListener;
    private final int listSizePerKey;

    public FixedSizePool(int listSizePerKey) {
        if (listSizePerKey <= 0) {
            throw new IllegalArgumentException("Pool size must be greater than zero: " + listSizePerKey);
        }
        this.listSizePerKey = listSizePerKey;
    }

    @Override
    public void init(IInstantiationListener<T, P> objectInstantiationListener, IActivationListener<T, P> objectActivationListener, IPassivationListener<T, P> objectPassivationListener, IDisposalListener<T, P> objectDisposalListener) {
        this.instantiationListener = objectInstantiationListener;
        this.activationListener = objectActivationListener;
        this.passivationListener = objectPassivationListener;
        this.disposalListener = objectDisposalListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I extends T> I borrowObject(Class<I> clazz, P parameter) throws InstantiationException, IllegalAccessException {
        T instance;
        FixedSizePool fixedSizePool = this;
        synchronized (fixedSizePool) {
            if (this.instances == null) {
                throw new IllegalStateException("The pool has already been disposed of");
            }
            Pair<Class<Class<I>>, P> key = new Pair<Class<Class<I>>, P>(clazz, parameter);
            ArrayList<T> list = this.instances.get(key);
            if (list == null) {
                list = this.createInstancePool(clazz, parameter);
                this.instances.put(key, list);
            }
            while (list.size() == 0) {
                try {
                    this.wait();
                    if (this.instances != null) continue;
                    throw new InstantiationException("Pool disposed while waiting.");
                }
                catch (InterruptedException e) {
                    throw new InstantiationException("Interrupted while waiting for the object pool: " + clazz + ", " + parameter);
                }
            }
            instance = list.remove(list.size() - 1);
        }
        if (this.activationListener != null) {
            this.activationListener.activate(instance, parameter);
        }
        return (I)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnObject(T object, P parameter) {
        if (object == null) {
            throw new IllegalArgumentException("Null could not have been acquired from this pool.");
        }
        if (this.passivationListener != null) {
            this.passivationListener.passivate(object, parameter);
        }
        FixedSizePool fixedSizePool = this;
        synchronized (fixedSizePool) {
            if (this.instances == null) {
                return;
            }
            Pair key = new Pair(object.getClass(), parameter);
            ArrayList<T> list = this.instances.get(key);
            if (list == null) {
                throw new IllegalStateException("Returning an object that was never borrowed: " + object);
            }
            for (T reference : list) {
                if (reference == null || reference != object) continue;
                throw new IllegalStateException("Object has not been borrowed");
            }
            list.add(object);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        FixedSizePool fixedSizePool = this;
        synchronized (fixedSizePool) {
            if (this.instances == null) {
                return;
            }
            Map<Pair<Class<T>, P>, ArrayList<T>> instancesRef = this.instances;
            this.instances = null;
            this.notifyAll();
            for (Map.Entry<Pair<Class<T>, P>, ArrayList<T>> entry : instancesRef.entrySet()) {
                for (T instance : entry.getValue()) {
                    if (instance == null || this.disposalListener == null) continue;
                    this.disposalListener.dispose(instance, entry.getKey().objectB);
                }
            }
        }
    }

    private <I extends T> ArrayList<T> createInstancePool(Class<I> clazz, P parameter) throws InstantiationException, IllegalAccessException {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.listSizePerKey; ++i) {
            I instance = clazz.newInstance();
            if (this.instantiationListener != null) {
                this.instantiationListener.objectInstantiated(instance, parameter);
            }
            list.add(instance);
        }
        return list;
    }
}

