/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.resource.ResourceLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultLexicalDataFactoryDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.text.linguistic.DefaultLexicalDataFactory";
    public final String prefix = "";
    public final String title = "The default management of lexical resources";
    public final String label = "";
    public final String description = "Resources are read from disk, cached and shared between <b>all</b> threads using this class. Additional attributes control resource reloading and merging: <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.resourceLookup</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.reloadResources</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.mergeResources</code>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getTitle() {
        return "The default management of lexical resources";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "Resources are read from disk, cached and shared between <b>all</b> threads using this class. Additional attributes control resource reloading and merging: <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.resourceLookup</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.reloadResources</code>, <code>org.carrot2.text.linguistic.DefaultLexicalDataFactory.mergeResources</code>.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(DefaultLexicalDataFactoryDescriptor.attributes.reloadResources);
        ownAttrs.add(DefaultLexicalDataFactoryDescriptor.attributes.mergeResources);
        ownAttrs.add(DefaultLexicalDataFactoryDescriptor.attributes.resourceLookup);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(DefaultLexicalDataFactoryDescriptor.attributes.reloadResources);
        allAttrs.add(DefaultLexicalDataFactoryDescriptor.attributes.mergeResources);
        allAttrs.add(DefaultLexicalDataFactoryDescriptor.attributes.resourceLookup);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder reloadResources(boolean value) {
            this.map.put("reload-resources", value);
            return this;
        }

        public AttributeBuilder mergeResources(boolean value) {
            this.map.put("merge-resources", value);
            return this;
        }

        public AttributeBuilder resourceLookup(ResourceLookup value) {
            this.map.put("resource-lookup", value);
            return this;
        }

        public AttributeBuilder resourceLookup(Class<? extends ResourceLookup> clazz) {
            this.map.put("resource-lookup", clazz);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo reloadResources = new AttributeInfo("reload-resources", "org.carrot2.text.linguistic.DefaultLexicalDataFactory", "reloadResources", "Reloads cached stop words and stop labels on every processing request. For best\nperformance, lexical resource reloading should be disabled in production.\n\n<p>This flag is reset to <code>false</code> after successful resource reload to prevent\nmultiple resource reloads during the same processing cycle.</p>", "Reload lexical resources", "Reloads cached stop words and stop labels on every processing request", "For best performance, lexical resource reloading should be disabled in production. <p>This flag is reset to <code>false</code> after successful resource reload to prevent multiple resource reloads during the same processing cycle.</p>", "Preprocessing", AttributeLevel.MEDIUM, null);
        public final AttributeInfo mergeResources = new AttributeInfo("merge-resources", "org.carrot2.text.linguistic.DefaultLexicalDataFactory", "mergeResources", "Merges stop words and stop labels from all known languages. If set to\n<code>false</code>, only stop words and stop labels of the active language will be\nused. If set to <code>true</code>, stop words from all {@link org.carrot2.core.LanguageCode}s will\nbe used together and stop labels from all languages will be used together, no\nmatter the active language. Lexical resource merging is useful when clustering data\nin a mix of different languages and should increase clustering quality in such\nsettings.", "Merge lexical resources", "Merges stop words and stop labels from all known languages", "If set to <code>false</code>, only stop words and stop labels of the active language will be used. If set to <code>true</code>, stop words from all <code>org.carrot2.core.LanguageCode</code>s will be used together and stop labels from all languages will be used together, no matter the active language. Lexical resource merging is useful when clustering data in a mix of different languages and should increase clustering quality in such settings.", "Preprocessing", AttributeLevel.MEDIUM, null);
        public final AttributeInfo resourceLookup = new AttributeInfo("resource-lookup", "org.carrot2.text.linguistic.DefaultLexicalDataFactory", "resourceLookup", "Lexical resource lookup facade. By default, resources are sought in the current\nthread's context class loader. An override of this attribute is possible both at\nthe initialization time and at processing time.", "Resource lookup facade", "Lexical resource lookup facade", "By default, resources are sought in the current thread's context class loader. An override of this attribute is possible both at the initialization time and at processing time.", "Preprocessing", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String RELOAD_RESOURCES = "reload-resources";
        public static final String MERGE_RESOURCES = "merge-resources";
        public static final String RESOURCE_LOOKUP = "resource-lookup";

        protected Keys() {
        }
    }
}

