/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.linguistic;

import com.carrotsearch.hppc.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.util.MutableCharArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultLexicalData
implements ILexicalData {
    private final ObjectOpenHashSet<MutableCharArray> stopwords;
    private final Pattern stoplabelPattern;

    public DefaultLexicalData(ObjectOpenHashSet<MutableCharArray> stopwords, ArrayList<Pattern> stoplabels) {
        this.stopwords = stopwords;
        this.stoplabelPattern = DefaultLexicalData.union(stoplabels);
    }

    @Override
    public boolean isCommonWord(MutableCharArray word) {
        return this.stopwords.contains((Object)word);
    }

    @Override
    public boolean isStopLabel(CharSequence label) {
        if (this.stoplabelPattern == null) {
            return false;
        }
        return this.stoplabelPattern.matcher(label).matches();
    }

    private static Pattern union(ArrayList<Pattern> patterns) {
        StringBuilder union = new StringBuilder();
        if (patterns.size() > 0) {
            union.append("(");
            for (int i = 0; i < patterns.size(); ++i) {
                if (i > 0) {
                    union.append(")|(");
                }
                union.append(patterns.get(i).toString());
            }
            union.append(")");
            return Pattern.compile(union.toString());
        }
        return null;
    }
}

