/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.FSDirectory;
import org.carrot2.util.simplexml.ISimpleXmlWrapper;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Root(name="fsdirectory")
public final class FSDirectoryWrapper
implements ISimpleXmlWrapper<FSDirectory> {
    private FSDirectory value;
    @Element
    private String indexPath;

    @Override
    public FSDirectory getValue() {
        return this.value;
    }

    @Override
    public void setValue(FSDirectory value) {
        this.value = value;
    }

    @Persist
    void beforeSerialization() {
        this.indexPath = this.value.getDirectory().getAbsolutePath();
    }

    @Commit
    void afterDeserialization() {
        try {
            this.value = FSDirectory.open((File)new File(this.indexPath));
        }
        catch (IOException e) {
            LoggerFactory.getLogger(FSDirectoryWrapper.class).warn("Could not deserialize index location.", (Throwable)e);
        }
    }
}

