/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.google;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.source.xml.RemoteXmlSimpleSearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GoogleDesktopDocumentSourceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.google.GoogleDesktopDocumentSource";
    public final String prefix = "GoogleDesktopDocumentSource";
    public final String title = "Fetches documents from an instance of Google Desktop search engine";
    public final String label = "";
    public final String description = "";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "GoogleDesktopDocumentSource";
    }

    @Override
    public String getTitle() {
        return "Fetches documents from an instance of Google Desktop search engine";
    }

    @Override
    public String getLabel() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(GoogleDesktopDocumentSourceDescriptor.attributes.queryUrl);
        ownAttrs.add(GoogleDesktopDocumentSourceDescriptor.attributes.keepHighlights);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(GoogleDesktopDocumentSourceDescriptor.attributes.queryUrl);
        allAttrs.add(GoogleDesktopDocumentSourceDescriptor.attributes.keepHighlights);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.start);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.results);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.query);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.documents);
        allAttrs.add(SearchEngineBaseDescriptor.attributes.compressed);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends RemoteXmlSimpleSearchEngineBaseDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder queryUrl(String value) {
            this.map.put("GoogleDesktopDocumentSource.queryUrl", value);
            return this;
        }

        public AttributeBuilder keepHighlights(boolean value) {
            this.map.put("GoogleDesktopDocumentSource.keepHighlights", value);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo queryUrl = new AttributeInfo("GoogleDesktopDocumentSource.queryUrl", "org.carrot2.source.google.GoogleDesktopDocumentSource", "queryUrl", "Query URL. Installation-specific URL at which Google Desktop search service is\navailable. On Windows machines, the URL is available at the\n<code>HKEY_CURRENT_USER\\Software\\Google\\Google Desktop\\API\\search_url</code> system\nregistry key and Carrot2 will attempt to automatically read the value from the\nregistry when run with Administrator provileges. Please consult <a\nhref=\"http://code.google.com/apis/desktop/docs/queryapi.html#httpxml\">Google\nDesktop API documentation</a> for further instructions on how to determine the\nquery URL on other systems.", "Query URL", "Query URL", "Installation-specific URL at which Google Desktop search service is available. On Windows machines, the URL is available at the <code>HKEY_CURRENT_USER\\Software\\Google\\Google Desktop\\API\\search_url</code> system registry key and Carrot2 will attempt to automatically read the value from the registry when run with Administrator provileges. Please consult <a href=\"http://code.google.com/apis/desktop/docs/queryapi.html.httpxml\">Google Desktop API documentation</a> for further instructions on how to determine the query URL on other systems.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo keepHighlights = new AttributeInfo("GoogleDesktopDocumentSource.keepHighlights", "org.carrot2.source.google.GoogleDesktopDocumentSource", "keepHighlights", "Keep query word highlighting. Google by default highlights query words in snippets\nusing the bold HTML tag. Set this attribute to <code>true</code> to keep these\nhighlights.", "Keep highlights", "Keep query word highlighting", "Google by default highlights query words in snippets using the bold HTML tag. Set this attribute to <code>true</code> to keep these highlights.", "Postprocessing", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends RemoteXmlSimpleSearchEngineBaseDescriptor.Keys {
        public static final String QUERY_URL = "GoogleDesktopDocumentSource.queryUrl";
        public static final String KEEP_HIGHLIGHTS = "GoogleDesktopDocumentSource.keepHighlights";

        protected Keys() {
        }
    }
}

