/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.boss;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.boss.BossSearchServiceDescriptor;
import org.carrot2.source.boss.Dimensions;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BossImageSearchServiceDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.boss.BossImageSearchService";
    public final String prefix = "BossImageSearchService";
    public final String title = "Sends queries to Yahoo! Boss Image search service";
    public final String label = "Yahoo Boss Image Search Service";
    public final String description = "Instances of this class are thread-safe. <p> Attributes of this class correspond to Yahoo's documentation (see links below). Note the following service terms given by Yahoo: <b>You must:</b> <ol> <li>display the title or abstract of the image when presented in the search results; <li>display at least the first 40 characters of the referurl field which indicates the source page; <li>for the source page referurl, use the unmodified referclickurl field to navigate to the respective source page; <li>If the image is made clickable, either use unmodified refereclickurl (to the source HTML page) or clickurl (to the image) for the navigation link. </ol>";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "BossImageSearchService";
    }

    @Override
    public String getTitle() {
        return "Sends queries to Yahoo! Boss Image search service";
    }

    @Override
    public String getLabel() {
        return "Yahoo Boss Image Search Service";
    }

    @Override
    public String getDescription() {
        return "Instances of this class are thread-safe. <p> Attributes of this class correspond to Yahoo's documentation (see links below). Note the following service terms given by Yahoo: <b>You must:</b> <ol> <li>display the title or abstract of the image when presented in the search results; <li>display at least the first 40 characters of the referurl field which indicates the source page; <li>for the source page referurl, use the unmodified referclickurl field to navigate to the respective source page; <li>If the image is made clickable, either use unmodified refereclickurl (to the source HTML page) or clickurl (to the image) for the navigation link. </ol>";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(BossImageSearchServiceDescriptor.attributes.serviceURI);
        ownAttrs.add(BossImageSearchServiceDescriptor.attributes.filter);
        ownAttrs.add(BossImageSearchServiceDescriptor.attributes.dimensions);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(BossImageSearchServiceDescriptor.attributes.serviceURI);
        allAttrs.add(BossImageSearchServiceDescriptor.attributes.filter);
        allAttrs.add(BossImageSearchServiceDescriptor.attributes.dimensions);
        allAttrs.add(BossSearchServiceDescriptor.attributes.appid);
        allAttrs.add(BossSearchServiceDescriptor.attributes.sites);
        allAttrs.add(BossSearchServiceDescriptor.attributes.languageAndRegion);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder
    extends BossSearchServiceDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder serviceURI(String value) {
            this.map.put("BossImageSearchService.serviceURI", value);
            return this;
        }

        public AttributeBuilder filter(boolean value) {
            this.map.put("BossImageSearchService.filter", value);
            return this;
        }

        public AttributeBuilder dimensions(Dimensions value) {
            this.map.put("BossImageSearchService.dimensions", (Object)value);
            return this;
        }

        public AttributeBuilder dimensions(Class<? extends Dimensions> clazz) {
            this.map.put("BossImageSearchService.dimensions", clazz);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo serviceURI = new AttributeInfo("BossImageSearchService.serviceURI", "org.carrot2.source.boss.BossImageSearchService", "serviceURI", "Boss Image search service URI. Specifies the URI at which Yahoo Boss Image Search\nAPI is available. The <code>${query}</code> place holder will be replaced with\nthe URL-encoded text of the processed query.", "Service URI", "Boss Image search service URI", "Specifies the URI at which Yahoo Boss Image Search API is available. The <code>${query}</code> place holder will be replaced with the URL-encoded text of the processed query.", "Service", AttributeLevel.ADVANCED, null);
        public final AttributeInfo filter = new AttributeInfo("BossImageSearchService.filter", "org.carrot2.source.boss.BossImageSearchService", "filter", "If enabled, excludes offensive content from the results.", "Offensive content filter", "If enabled, excludes offensive content from the results", null, "Results filtering", AttributeLevel.MEDIUM, null);
        public final AttributeInfo dimensions = new AttributeInfo("BossImageSearchService.dimensions", "org.carrot2.source.boss.BossImageSearchService", "dimensions", "The size of images to fetch. Small images are generally thumbnail or icon sized.\nMedium sized images are average sized; usually not exceeding an average screen\nsize. Large images are screen size or larger.", "Preferred size", "The size of images to fetch", "Small images are generally thumbnail or icon sized. Medium sized images are average sized; usually not exceeding an average screen size. Large images are screen size or larger.", "Results filtering", AttributeLevel.MEDIUM, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends BossSearchServiceDescriptor.Keys {
        public static final String SERVICE_URI = "BossImageSearchService.serviceURI";
        public static final String FILTER = "BossImageSearchService.filter";
        public static final String DIMENSIONS = "BossImageSearchService.dimensions";

        protected Keys() {
        }
    }
}

