/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.matrix.factorization;

import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.carrot2.matrix.factorization.IterativeMatrixFactorizationBase;

public class NonnegativeMatrixFactorizationED
extends IterativeMatrixFactorizationBase {
    public NonnegativeMatrixFactorizationED(DoubleMatrix2D A) {
        super(A);
    }

    public void compute() {
        double eps = 1.0E-9;
        this.U = this.doubleFactory2D.make(this.A.rows(), this.k);
        this.V = this.doubleFactory2D.make(this.A.columns(), this.k);
        this.seedingStrategy.seed(this.A, this.U, this.V);
        DoubleMatrix2D T = this.doubleFactory2D.make(this.k, this.k);
        DoubleMatrix2D UT1 = this.doubleFactory2D.make(this.A.rows(), this.k);
        DoubleMatrix2D UT2 = this.doubleFactory2D.make(this.A.rows(), this.k);
        DoubleMatrix2D VT1 = this.doubleFactory2D.make(this.A.columns(), this.k);
        DoubleMatrix2D VT2 = this.doubleFactory2D.make(this.A.columns(), this.k);
        UnaryFunction plusEps = Functions.plus((double)eps);
        if (this.stopThreshold >= 0.0) {
            this.updateApproximationError();
        }
        for (int i = 0; i < this.maxIterations; ++i) {
            this.U.zMult(this.U, T, 1.0, 0.0, true, false);
            this.A.zMult(this.U, VT1, 1.0, 0.0, true, false);
            this.V.zMult(T, VT2);
            VT1.assign(plusEps);
            VT2.assign(plusEps);
            VT1.assign(VT2, Functions.div);
            this.V.assign(VT1, Functions.mult);
            this.V.zMult(this.V, T, 1.0, 0.0, true, false);
            this.A.zMult(this.V, UT1);
            this.U.zMult(T, UT2);
            UT1.assign(plusEps);
            UT2.assign(plusEps);
            UT1.assign(UT2, Functions.div);
            this.U.assign(UT1, Functions.mult);
            ++this.iterationsCompleted;
            if (this.stopThreshold >= 0.0 && this.updateApproximationError()) break;
        }
        if (this.ordered) {
            this.order();
        }
    }

    public String toString() {
        return "NMF-ED-" + this.seedingStrategy.toString();
    }
}

