/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.carrot2.core.IProcessingComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessingComponentConfiguration {
    public final Class<? extends IProcessingComponent> componentClass;
    public final String componentId;
    public final Map<String, Object> attributes;

    public ProcessingComponentConfiguration(Class<? extends IProcessingComponent> componentClass, String componentId, Map<String, Object> attributes) {
        this.componentClass = componentClass;
        this.componentId = componentId;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public ProcessingComponentConfiguration(Class<? extends IProcessingComponent> componentClass, String componentId) {
        this(componentClass, componentId, Collections.emptyMap());
    }

    static Map<String, ProcessingComponentConfiguration> indexByComponentId(ProcessingComponentConfiguration ... configurations) {
        HashMap componentIdToConfiguration = Maps.newHashMapWithExpectedSize((int)configurations.length);
        for (ProcessingComponentConfiguration configuration : configurations) {
            if (componentIdToConfiguration.put(configuration.componentId, configuration) == null) continue;
            throw new IllegalArgumentException("Duplicate processing component id: " + configuration.componentId);
        }
        return Collections.unmodifiableMap(componentIdToConfiguration);
    }
}

