/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.clustering.synthetic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ByUrlClusteringAlgorithmDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.clustering.synthetic.ByUrlClusteringAlgorithm";
    public final String prefix = "";
    public final String title = "Hierarchically clusters documents according to their content URLs";
    public final String label = "By URL Clustering";
    public final String description = "<code>Document.CONTENT_URL</code> property will be used to obtain a document's URL. <p> Groups at the top level of the hierarchy will correspond to the last segments of the URLs, usually domain suffixes, such as \".com\" or \".co.uk\". Subgroups will be created based on further segments of the URLs, very often domains subdomains, e.g. \"yahoo.com\", \"bbc.co.uk\" and then e.g. \"mail.yahoo.com\", \"news.yahoo.com\". The \"www\" segment of the URLs will be ignored. <p> Clusters will be ordered by size (number of documents) descendingly; in case of equal sizes, alphabetically by URL, see <code>Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR</code>.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    public static AttributeBuilder attributeBuilder(Map<String, Object> attributeValues) {
        return new AttributeBuilder(attributeValues);
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getTitle() {
        return "Hierarchically clusters documents according to their content URLs";
    }

    @Override
    public String getLabel() {
        return "By URL Clustering";
    }

    @Override
    public String getDescription() {
        return "<code>Document.CONTENT_URL</code> property will be used to obtain a document's URL. <p> Groups at the top level of the hierarchy will correspond to the last segments of the URLs, usually domain suffixes, such as \".com\" or \".co.uk\". Subgroups will be created based on further segments of the URLs, very often domains subdomains, e.g. \"yahoo.com\", \"bbc.co.uk\" and then e.g. \"mail.yahoo.com\", \"news.yahoo.com\". The \"www\" segment of the URLs will be ignored. <p> Clusters will be ordered by size (number of documents) descendingly; in case of equal sizes, alphabetically by URL, see <code>Cluster.BY_REVERSED_SIZE_AND_LABEL_COMPARATOR</code>.";
    }

    @Override
    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    @Override
    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    @Override
    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    static {
        HashSet<AttributeInfo> ownAttrs = new HashSet<AttributeInfo>();
        ownAttrs.add(ByUrlClusteringAlgorithmDescriptor.attributes.documents);
        ownAttrs.add(ByUrlClusteringAlgorithmDescriptor.attributes.clusters);
        HashSet<AttributeInfo> allAttrs = new HashSet<AttributeInfo>();
        allAttrs.add(ByUrlClusteringAlgorithmDescriptor.attributes.documents);
        allAttrs.add(ByUrlClusteringAlgorithmDescriptor.attributes.clusters);
        allAttributes = Collections.unmodifiableSet(allAttrs);
        ownAttributes = Collections.unmodifiableSet(ownAttrs);
        HashMap<String, AttributeInfo> allAttrsByKey = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> allAttrsByFieldName = new HashMap<String, AttributeInfo>();
        for (AttributeInfo ai : allAttrs) {
            allAttrsByKey.put(ai.key, ai);
            allAttrsByFieldName.put(ai.fieldName, ai);
        }
        allAttributesByKey = Collections.unmodifiableMap(allAttrsByKey);
        allAttributesByFieldName = Collections.unmodifiableMap(allAttrsByFieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public AttributeBuilder documents(List<Document> value) {
            this.map.put("documents", value);
            return this;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }
    }

    public static final class Attributes {
        public final AttributeInfo documents;
        public final AttributeInfo clusters;

        private Attributes() {
            this.documents = new AttributeInfo("documents", "org.carrot2.clustering.synthetic.ByUrlClusteringAlgorithm", "documents", "Documents to cluster.", null, "Documents to cluster", null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.clusters = new AttributeInfo("clusters", "org.carrot2.clustering.synthetic.ByUrlClusteringAlgorithm", "clusters", "Clusters created by the algorithm.", null, "Clusters created by the algorithm", null, null, null, CommonAttributesDescriptor.attributes.clusters);
        }
    }

    public static class Keys {
        public static final String DOCUMENTS = "documents";
        public static final String CLUSTERS = "clusters";

        protected Keys() {
        }
    }
}

