/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xslf.extractor.XSLFPowerPointExtractor;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.extractor.XSSFEventBasedExcelExtractor;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.POIXMLTextExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSLFPowerPointExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.parser.microsoft.ooxml.XWPFWordExtractorDecorator;
import org.apache.tika.sax.EndDocumentShieldingContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OOXMLExtractorFactory {
    public static void parse(InputStream stream, ContentHandler baseHandler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Locale locale = (Locale)context.get(Locale.class, (Object)Locale.getDefault());
        ExtractorFactory.setThreadPrefersEventExtractors((boolean)true);
        try {
            AbstractOOXMLExtractor extractor;
            POIXMLTextExtractor poiExtractor;
            TikaInputStream tis = TikaInputStream.cast((InputStream)stream);
            if (tis != null && tis.getOpenContainer() instanceof OPCPackage) {
                poiExtractor = ExtractorFactory.createExtractor((OPCPackage)((OPCPackage)tis.getOpenContainer()));
            } else if (tis != null && tis.hasFile()) {
                poiExtractor = (POIXMLTextExtractor)ExtractorFactory.createExtractor((File)tis.getFile());
            } else {
                CloseShieldInputStream shield = new CloseShieldInputStream(stream);
                poiExtractor = (POIXMLTextExtractor)ExtractorFactory.createExtractor((InputStream)shield);
            }
            POIXMLDocument document = poiExtractor.getDocument();
            if (poiExtractor instanceof XSSFEventBasedExcelExtractor) {
                extractor = new XSSFExcelExtractorDecorator(context, (XSSFEventBasedExcelExtractor)poiExtractor, locale);
            } else {
                if (document == null) {
                    throw new TikaException("Expecting UserModel based POI OOXML extractor with a document, but none found. The extractor returned was a " + poiExtractor);
                }
                extractor = document instanceof XMLSlideShow ? new XSLFPowerPointExtractorDecorator(context, (XSLFPowerPointExtractor)poiExtractor) : (document instanceof XWPFDocument ? new XWPFWordExtractorDecorator(context, (XWPFWordExtractor)poiExtractor) : new POIXMLTextExtractorDecorator(context, poiExtractor));
            }
            EndDocumentShieldingContentHandler handler = new EndDocumentShieldingContentHandler(baseHandler);
            extractor.getXHTML((ContentHandler)handler, metadata, context);
            extractor.getMetadataExtractor().extract(metadata);
            handler.reallyEndDocument();
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().startsWith("No supported documents found")) {
                throw new TikaException("TIKA-418: RuntimeException while getting content for thmx and xps file types", (Throwable)e);
            }
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
        catch (OpenXML4JException e) {
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
        catch (XmlException e) {
            throw new TikaException("Error creating OOXML extractor", (Throwable)e);
        }
    }
}

