/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.poi.hwpf.model.ListData;
import org.apache.poi.hwpf.model.ListFormatOverride;
import org.apache.poi.hwpf.model.ListFormatOverrideLevel;
import org.apache.poi.hwpf.model.ListLevel;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
public final class ListTables {
    private static final int LIST_DATA_SIZE = 28;
    private static final int LIST_FORMAT_OVERRIDE_SIZE = 16;
    private static POILogger log = POILogFactory.getLogger(ListTables.class);
    ListMap _listMap = new ListMap();
    ArrayList<ListFormatOverride> _overrideList = new ArrayList();

    public ListTables() {
    }

    public ListTables(byte[] tableStream, int lstOffset, int lfoOffset) {
        int length = LittleEndian.getShort((byte[])tableStream, (int)lstOffset);
        int levelOffset = (lstOffset += 2) + length * 28;
        for (int x = 0; x < length; ++x) {
            ListData lst = new ListData(tableStream, lstOffset);
            this._listMap.put(lst.getLsid(), lst);
            lstOffset += 28;
            int num = lst.numLevels();
            for (int y = 0; y < num; ++y) {
                ListLevel lvl = new ListLevel(tableStream, levelOffset);
                lst.setLevel(y, lvl);
                levelOffset += lvl.getSizeInBytes();
            }
        }
        length = LittleEndian.getInt((byte[])tableStream, (int)lfoOffset);
        int lfolvlOffset = (lfoOffset += 4) + 16 * length;
        for (int x = 0; x < length; ++x) {
            ListFormatOverride lfo = new ListFormatOverride(tableStream, lfoOffset);
            lfoOffset += 16;
            int num = lfo.numOverrides();
            for (int y = 0; y < num; ++y) {
                while (tableStream[lfolvlOffset] == -1) {
                    ++lfolvlOffset;
                }
                ListFormatOverrideLevel lfolvl = new ListFormatOverrideLevel(tableStream, lfolvlOffset);
                lfo.setOverride(y, lfolvl);
                lfolvlOffset += lfolvl.getSizeInBytes();
            }
            this._overrideList.add(lfo);
        }
    }

    public int addList(ListData lst, ListFormatOverride override) {
        int lsid = lst.getLsid();
        while (this._listMap.get(lsid) != null) {
            lsid = lst.resetListID();
            override.setLsid(lsid);
        }
        this._listMap.put(lsid, lst);
        this._overrideList.add(override);
        return lsid;
    }

    public void writeListDataTo(HWPFOutputStream tableStream) throws IOException {
        int listSize = this._listMap.size();
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        byte[] shortHolder = new byte[2];
        LittleEndian.putShort((byte[])shortHolder, (short)((short)listSize));
        tableStream.write(shortHolder);
        for (Integer x : this._listMap.sortedKeys()) {
            ListData lst = this._listMap.get(x);
            tableStream.write(lst.toByteArray());
            ListLevel[] lvls = lst.getLevels();
            for (int y = 0; y < lvls.length; ++y) {
                levelBuf.write(lvls[y].toByteArray());
            }
        }
        tableStream.write(levelBuf.toByteArray());
    }

    public void writeListOverridesTo(HWPFOutputStream tableStream) throws IOException {
        ByteArrayOutputStream levelBuf = new ByteArrayOutputStream();
        int size = this._overrideList.size();
        byte[] intHolder = new byte[4];
        LittleEndian.putInt((byte[])intHolder, (int)size);
        tableStream.write(intHolder);
        for (int x = 0; x < size; ++x) {
            ListFormatOverride lfo = this._overrideList.get(x);
            tableStream.write(lfo.toByteArray());
            ListFormatOverrideLevel[] lfolvls = lfo.getLevelOverrides();
            for (int y = 0; y < lfolvls.length; ++y) {
                levelBuf.write(lfolvls[y].toByteArray());
            }
        }
        tableStream.write(levelBuf.toByteArray());
    }

    public ListFormatOverride getOverride(int lfoIndex) {
        return this._overrideList.get(lfoIndex - 1);
    }

    public int getOverrideCount() {
        return this._overrideList.size();
    }

    public int getOverrideIndexFromListID(int lstid) {
        int returnVal = -1;
        int size = this._overrideList.size();
        for (int x = 0; x < size; ++x) {
            ListFormatOverride next = this._overrideList.get(x);
            if (next.getLsid() != lstid) continue;
            returnVal = x + 1;
            break;
        }
        if (returnVal == -1) {
            throw new NoSuchElementException("No list found with the specified ID");
        }
        return returnVal;
    }

    public ListLevel getLevel(int listID, int level) {
        ListData lst = this._listMap.get(listID);
        if (level < lst.numLevels()) {
            ListLevel lvl = lst.getLevels()[level];
            return lvl;
        }
        log.log(POILogger.WARN, (Object)("Requested level " + level + " which was greater than the maximum defined (" + lst.numLevels() + ")"));
        return null;
    }

    public ListData getListData(int listID) {
        return this._listMap.get(listID);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ListTables tables = (ListTables)obj;
        if (this._listMap.size() == tables._listMap.size()) {
            for (Integer key : this._listMap.keySet()) {
                ListData lst2;
                ListData lst1 = this._listMap.get(key);
                if (lst1.equals(lst2 = tables._listMap.get(key))) continue;
                return false;
            }
            int size = this._overrideList.size();
            if (size == tables._overrideList.size()) {
                for (int x = 0; x < size; ++x) {
                    if (this._overrideList.get(x).equals(tables._overrideList.get(x))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListMap
    implements Map<Integer, ListData> {
        private ArrayList<Integer> keyList = new ArrayList();
        private HashMap<Integer, ListData> parent = new HashMap();

        private ListMap() {
        }

        @Override
        public void clear() {
            this.keyList.clear();
            this.parent.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.parent.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.parent.containsValue(value);
        }

        @Override
        public ListData get(Object key) {
            return this.parent.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.parent.isEmpty();
        }

        @Override
        public ListData put(Integer key, ListData value) {
            this.keyList.add(key);
            return this.parent.put(key, value);
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends ListData> map) {
            for (Map.Entry<? extends Integer, ? extends ListData> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public ListData remove(Object key) {
            this.keyList.remove(key);
            return this.parent.remove(key);
        }

        @Override
        public int size() {
            return this.parent.size();
        }

        @Override
        public Set<Map.Entry<Integer, ListData>> entrySet() {
            throw new IllegalStateException("Use sortedKeys() + get() instead");
        }

        public List<Integer> sortedKeys() {
            return Collections.unmodifiableList(this.keyList);
        }

        @Override
        public Set<Integer> keySet() {
            throw new IllegalStateException("Use sortedKeys() instead");
        }

        @Override
        public Collection<ListData> values() {
            ArrayList<ListData> values = new ArrayList<ListData>();
            for (Integer key : this.keyList) {
                values.add(this.parent.get(key));
            }
            return values;
        }
    }
}

