/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.ArrayList;
import java.util.List;
import org.simpleframework.xml.core.Builder;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.Creator;
import org.simpleframework.xml.core.Criteria;
import org.simpleframework.xml.core.Index;
import org.simpleframework.xml.core.Parameter;
import org.simpleframework.xml.core.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassCreator
implements Creator {
    private final List<Builder> list;
    private final Builder primary;
    private final Index index;
    private final Class type;

    public ClassCreator(List<Builder> list, Index index, Builder primary) {
        this.type = index.getType();
        this.primary = primary;
        this.index = index;
        this.list = list;
    }

    @Override
    public boolean isDefault() {
        return this.primary != null;
    }

    @Override
    public Object getInstance(Context context) throws Exception {
        return this.primary.getInstance(context);
    }

    @Override
    public Object getInstance(Context context, Criteria criteria) throws Exception {
        Builder builder = this.getBuilder(context, criteria);
        if (builder == null) {
            throw new PersistenceException("Constructor not matched for %s", this.type);
        }
        return builder.getInstance(context, criteria);
    }

    private Builder getBuilder(Context context, Criteria criteria) throws Exception {
        Builder result = this.primary;
        double max = 0.0;
        for (Builder builder : this.list) {
            double score = builder.getScore(context, criteria);
            if (!(score > max)) continue;
            result = builder;
            max = score;
        }
        return result;
    }

    @Override
    public Parameter getParameter(String name) {
        return (Parameter)this.index.get(name);
    }

    @Override
    public List<Parameter> getParameters() {
        return this.index.getParameters();
    }

    @Override
    public List<Builder> getBuilders() {
        return new ArrayList<Builder>(this.list);
    }

    public String toString() {
        return String.format("creator for %s", this.type);
    }
}

