
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /Users/dossy/Desktop/cvs/aolserver/doc/ns_filter.n,v 1.5 2009/12/08 15:33:00 jgdavidson Exp $
'\"
'\" 
.so man.macros

.TH ns_filter n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_register_filter, ns_register_trace \- Register connection callbacks
.SH SYNOPSIS
.sp
\fBns_register_trace \fImethod url script ?arg?\fR
.sp
\fBns_register_filter read\fR \fImethod url script ?arg?\fR
.sp
\fBns_register_filter prequeue\fR \fImethod url script ?arg?\fR
.sp
\fBns_register_filter preauth\fR \fImethod url script ?arg?\fR
.sp
\fBns_register_filter postauth\fR \fImethod url script ?arg?\fR
.sp
\fBns_register_filter write\fR \fImethod url script ?arg?\fR
.sp
\fBns_register_filter trace\fR \fImethod url script ?arg?\fR
.BE

.SH DESCRIPTION
.PP
The \fBns_register_filter\fR and \fBns_register_trace\fR commands
arrange for a Tcl procedures to be called at the requested state
during a connections lifetime.

.PP
The \fImethod\fR and \fIurl\fR arguments are specified using
glob-style pattern matching to indicate for which requests the
\fIproc\fR should be invoked.  This allows methods and/or urls to
match more than one filter, all of which would be executed in FIFO
order (unless a \fBfilter_break\fR or \fBfilter_return\fR exit code
is returned as described below).  For example:

.CS
# Invoke myproc before connection processing for any method
# of .tcl scripts in the /employees directory.
ns_register_filter postauth * /employees/*.tcl myproc

# Invoke monitor during read for file uploads at the /upload/* URL
ns_register_filter read POST /upload/* monitor

# Invoke logit at end of connection for all requests.
ns_register_filter trace * * logit
.CE

.PP
See the man pages for \fBstring(n)\fR for details on glob matching.
Note this matching approach differs from that of the \fBns_register_proc\fR
command which is designed to match the method exactly and the single
most specific url pattern.

.PP
The \fIproc\fR argument is the name of a Tcl procedure to invoke
when the connection has reached the requested state.  The \fIproc\fR
will be called with the string name of the connection state, e.g.,
\fIpostauth\fR, \fItrace\fR, etc.  If an optional \fIarg\fR string
is provided, that value will precede the reason string.

.PP
For \fBns_register_trace\fR, the results of the procedure call are
ignored.  For \fBns_register_filter\fR, the result must be
one of the following strings:

.TP
\fBfilter_ok\fR
The filter returned correctly and the server should continue
invoking additional filters, if any.

.TP
\fBfilter_break\fR
The filter returned correctly but the server should not
invoke any additional filters.

.TP
\fBfilter_return\fR
The filter returned correctly and as a side-effect generated a
response to the client, for example, through a call to the
\fBns_return\fR command.  The server should not invoke additional
filters and close the connection.

.PP
If \fIproc\fR returns any other value or raises and exception, the
server will stop invoking filters, generate an error response, and
close the connection.

.SH USAGE

.TP
\fBns_register_trace \fImethod url script ?arg?\fR
This is equivalent to \fBns_register_filter trace\fR
where the result is ignored.

.TP
\fBns_register_filter \fBread\fR \fImethod url script ?arg?\fR
Invokes the given \fIproc\fR after each read from the client within
the "driver" network I/O thread.  This callback is deferred until the
minimum of the requests+headers have been received.  It can be
useful to monitor the progress of a large file upload (see the
\fBEXAMPLE\fR below).  The interpreter and thread will remain the
same for all \fBread\fR callbacks but may differ from that used for
other callbacks.  Also, as the procedure is not called within a
connection thread, care must be taken that it executes quickly
without blocking to avoid stalling the other network I/O being
multiplexed by the driver thread.

.TP
\fBns_register_filter \fBprequeue\fR \fImethod url script ?arg?\fR
Invokes the given \fIproc\fR after the request and content have
been read from the client but before queueing for execution on a
connection thread.  This callback can be used to register other
network I/O waits; see \fBns_quewait\fR for details and an example.
The interpreter and thread used for \fBprequeue\fR callbacks will
differ from those used for other callbacks.  The \fBns_cls\fR command
can be used to manage data between the interpreters.  Also, as the
procedure is not called within a connection thread, care must be
taken that it executes quickly without blocking to avoid stalling
the other network I/O being multiplexed in the driver thread.

.TP
\fBns_register_filter \fBpreauth\fR \fImethod url script ?arg?\fR
Invoke \fIproc\fR just before the server performs request
authorization.  This callback will be invoked even if the 
requests is ultimately not authorized.

.TP
\fBns_register_filter \fBpostauth\fR \fImethod url script ?arg?\fR
Invoke \fIproc\fR after successful authorization.  If prior authorization
fails, this callback will not be invoked.

.TP
\fBns_register_filter \fBwrite\fR \fImethod url script ?arg?\fR
Invoke \fIproc\fR after each write to the client.  Note the
server normally buffers response output so this callback is
normally not invoked on each \fBns_adp_puts\fR and potentially
just once when flushing the connection output buffers.

.TP
\fBns_register_filter \fBtrace\fR \fImethod url script ?arg?\fR
Invoke \fIproc\fR after the server has sent a response to the
client and closed the connection.  This can be useful for
custom logging routines.

.SH EXAMPLE

.PP
The following example uses a \fBread\fR filter to update status of
a large HTTP POST to the /upload/\fIkey\fR url where \fIkey\fR is
some client-specified unique value.  While the upload is in progress,
it can be monitored with repeated GET requests to the /status/\fIkey\fR
url with the same \fIkey\fR:

.CS
#
# Register procs to receive uploads and check status
# mainted in an nsv array.
#

ns_register_proc POST /upload upload.post
ns_register_proc GET /status upload.status

proc upload.status {} {
	set key [ns_conn urlv 1]
	if {[catch {set status [nsv_get status $key]}]} {
		set status "unknown"
	}
	ns_return 200 text/plain $status
}

proc upload.post {} {
	set key [ns_conn urlv 1]
	nsv_unset status $key
	# ... do something with content ...
	ns_return 200 text/plain received
}


#
# Register a read filter ot update status
#

ns_register_filter read POST /upload/* upload.update

proc upload.update {why} {
	set key [ns_conn urlv 1]
	set expected [ns_conn contentlength]
	set received [ns_conn contentavail]
	set status [list $expected $received]
	nsv_set status $key $status
	return filter_ok
}
.CE

.SH "SEE ALSO"
ns_register_proc(n), ns_register_tag(n), ns_register_adptag(n), ns_quewait(n)
.CE
.SH KEYWORDS

