!*****************************************************************************
!
! Tutorial: How to ALPSize your applications
!
! Copyright (C) 2010-2013 by Synge Todo <wistaria@comp-phys.org>
!
! Permission is hereby granted, free of charge, to any person or organization
! obtaining a copy of the software and accompanying documentation covered by
! this license (the "Software") to use, reproduce, display, distribute,
! execute, and transmit the Software, and to prepare derivative works of the
! Software, and to permit third-parties to whom the Software is furnished to
! do so, all subject to the following:
!
! The copyright notices in the Software and this entire statement, including
! the above license grant, this restriction and the following disclaimer,
! must be included in all copies of the Software, in whole or in part, and
! all derivative works of the Software, unless such copies or derivative
! works are solely in the form of machine-executable object code generated by
! a source language processor.
!
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
! IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
! FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
! SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
! FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
! ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
! DEALINGS IN THE SOFTWARE.
!
!****************************************************************************

! subroutine omp_info
subroutine omp_info()
  implicit none
  integer :: mm,np,id,i
  integer :: omp_get_max_threads,omp_get_num_threads
  integer :: omp_get_thread_num

  write(*, *) "----- OMP INFO -----"
  mm = omp_get_max_threads()
  np = omp_get_num_threads()
  id = omp_get_thread_num()

  write(*,*) "MAX THREADS = ", mm
  write(*,*) "NUM THREADS = ",np
  write(*,*) "THREAD ID = ",id

  write(*, *) "--------------------"

  return
end subroutine omp_info

! subroutine alps_run
subroutine alps_run()
  return
end subroutine alps_run

! subroutine alps_init
subroutine alps_init(caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer :: caller(2)
  real*8 :: dval
  integer :: ival
  character*32 :: cval

  call omp_info()

  write(*, *) ' ##### alps_init() ##### '
  call alps_get_parameter(dval, 'X', ALPS_DOUBLE_PRECISION, caller)
  write(*, *) '  parameter X     = ',dval

  call alps_get_parameter(ival, 'Y', ALPS_INT, caller)
  write(*, *) '  parameter Y     = ',ival

  call alps_get_parameter(cval, "WORLD", ALPS_CHAR, caller)
  write(*, *) '  parameter WORLD = ',cval
  ! print '("parameter WORLD = (",a,")")', cval

  ival = 0
  call alps_parameter_defined(ival, 'Z', caller);
  write(*, *) '  defined parameter Z = ',ival, ''
  return
end subroutine alps_init

! alps_init_observables
subroutine alps_init_observables(caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer caller(2)
  ! write(*,*) 'alps_init_observables()'
  return
end subroutine alps_init_observables

! alps_progerss
subroutine alps_progress(prgrs, caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer caller(2)
  real*8 prgrs
  ! write(*,*) 'alps_init_observables()'
  prgrs = 1.0
end subroutine alps_progress

! alps_is_thermalized
subroutine alps_is_thermalized(thrmlz, caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer caller(2)
  integer thrmlz
  ! write(*, *) 'alps_is_thermalized()'
  thrmlz = 1
  return
end subroutine alps_is_thermalized

! alps_save
subroutine alps_save(caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer caller(2)
  integer ival(4)
  real rval(4)
  character*64 cval(4)
  integer i
  ! write(*, *) 'alps_save()'

  do i = 1, 4
     ival(i) = i * 10
     rval(i) = i * i * 0.1
  end do
  cval(1) = "one"
  cval(2) = "TWO"
  cval(3) = "Three"
  cval(4) = "four"

  call alps_dump(ival, 4, ALPS_INT, caller)
  call alps_dump(rval, 4, ALPS_REAL, caller)
  call alps_dump(cval, 4, ALPS_CHAR, caller)

  return
end subroutine alps_save

! alps_load
subroutine alps_load(caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer caller(2)
  !   write(*, *) 'alps_load()'
  return
end subroutine alps_load

! alps_finalize
subroutine alps_finalize(caller)
  implicit none
  include "alps/fortran/alps_fortran.h"
  integer caller(2)
  ! write(*, *) 'alps_finalize()'
  return
end subroutine alps_finalize
