/*
 *      Copyright (C) 2005-2008 Team XBMC
 *      http://www.xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

#ifndef XBPYTHREAD_H_
#define XBPYTHREAD_H_

#include "Python/Include/Python.h"
#include "utils/Thread.h"

class XBPython;

class XBPyThread : public CThread
{
public:
  XBPyThread(XBPython *pExecuter, int id);
  virtual ~XBPyThread();
  int evalFile(const char*);
  int evalString(const char*);
  int setArgv(const unsigned int, const char **);
  bool isDone();
  bool isStopping();
  void stop();

protected:
  XBPython      *m_pExecuter;
  PyThreadState *m_threadState;

  char type;
  char *source;
  char **argv;
  unsigned int  argc;
  bool done;
  bool stopping;
  int  m_id;

  virtual void OnStartup();
  virtual void Process();
  virtual void OnExit();
  virtual void OnException();
};

#endif // XBPYTHREAD_H_
