/** @file RNAparconv_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef RNAPARCONV_CMDL_H
#define RNAPARCONV_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNAPARCONV_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNAPARCONV_CMDLINE_PARSER_PACKAGE "RNAparconv"
#endif

#ifndef RNAPARCONV_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNAPARCONV_CMDLINE_PARSER_PACKAGE_NAME "RNAparconv"
#endif

#ifndef RNAPARCONV_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNAPARCONV_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct RNAparconv_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  char * output_arg;	/**< @brief Specify an output file name. If argument is missing the converted energy parameters are printed to 'stdout'.
  
.  */
  char * output_orig;	/**< @brief Specify an output file name. If argument is missing the converted energy parameters are printed to 'stdout'.
  
 original value given at command line.  */
  const char *output_help; /**< @brief Specify an output file name. If argument is missing the converted energy parameters are printed to 'stdout'.
  
 help description.  */
  char * input_arg;	/**< @brief Specify an input file name. If argument is missing the energy parameter input can be supplied via 'stdin'.
  
.  */
  char * input_orig;	/**< @brief Specify an input file name. If argument is missing the energy parameter input can be supplied via 'stdin'.
  
 original value given at command line.  */
  const char *input_help; /**< @brief Specify an input file name. If argument is missing the energy parameter input can be supplied via 'stdin'.
  
 help description.  */
  int vanilla_flag;	/**< @brief Print just as much as needed to represent the given energy parameters data set.
  This option overrides all other output settings!
  
 (default=off).  */
  const char *vanilla_help; /**< @brief Print just as much as needed to represent the given energy parameters data set.
  This option overrides all other output settings!
  
 help description.  */
  int dump_flag;	/**< @brief Just dump Vienna 1.8.4 energy parameters in format used since 2.0.
  This option skips any energy parameter input!
  
 (default=off).  */
  const char *dump_help; /**< @brief Just dump Vienna 1.8.4 energy parameters in format used since 2.0.
  This option skips any energy parameter input!
  
 help description.  */
  int silent_flag;	/**< @brief Print just energy parameters and appropriate comment lines but suppress all other output
  
 (default=off).  */
  const char *silent_help; /**< @brief Print just energy parameters and appropriate comment lines but suppress all other output
  
 help description.  */
  int without_HairpinE_flag;	/**< @brief Do not print converted hairpin energies and enthalpies
  
 (default=off).  */
  const char *without_HairpinE_help; /**< @brief Do not print converted hairpin energies and enthalpies
  
 help description.  */
  int without_StackE_flag;	/**< @brief Do not print converted stacking energies and enthalpies
  
 (default=off).  */
  const char *without_StackE_help; /**< @brief Do not print converted stacking energies and enthalpies
  
 help description.  */
  int without_IntE_flag;	/**< @brief Do not print converted interior loop energies, enthalpies and asymetry factors
  
 (default=off).  */
  const char *without_IntE_help; /**< @brief Do not print converted interior loop energies, enthalpies and asymetry factors
  
 help description.  */
  int without_BulgeE_flag;	/**< @brief Do not print converted bulge loop energies and enthalpies
  
 (default=off).  */
  const char *without_BulgeE_help; /**< @brief Do not print converted bulge loop energies and enthalpies
  
 help description.  */
  int without_MultiE_flag;	/**< @brief Do not print converted multi loop energies and enthalpies
  
 (default=off).  */
  const char *without_MultiE_help; /**< @brief Do not print converted multi loop energies and enthalpies
  
 help description.  */
  int without_MismatchE_flag;	/**< @brief Do not print converted exterior loop mismatch energies and enthalpies
  
 (default=off).  */
  const char *without_MismatchE_help; /**< @brief Do not print converted exterior loop mismatch energies and enthalpies
  
 help description.  */
  int without_MismatchH_flag;	/**< @brief Do not print converted hairpin mismatch energies and enthalpies
  
 (default=off).  */
  const char *without_MismatchH_help; /**< @brief Do not print converted hairpin mismatch energies and enthalpies
  
 help description.  */
  int without_MismatchI_flag;	/**< @brief Do not print converted interior loop mismatch energies and enthalpies
  
 (default=off).  */
  const char *without_MismatchI_help; /**< @brief Do not print converted interior loop mismatch energies and enthalpies
  
 help description.  */
  int without_MismatchM_flag;	/**< @brief Do not print converted multi loop mismatch energies and enthalpies
  
 (default=off).  */
  const char *without_MismatchM_help; /**< @brief Do not print converted multi loop mismatch energies and enthalpies
  
 help description.  */
  int without_Dangle5_flag;	/**< @brief Do not print converted 5' dangle energies and enthalpies
  
 (default=off).  */
  const char *without_Dangle5_help; /**< @brief Do not print converted 5' dangle energies and enthalpies
  
 help description.  */
  int without_Dangle3_flag;	/**< @brief Do not print converted 3' dangle energies and enthalpies
  
 (default=off).  */
  const char *without_Dangle3_help; /**< @brief Do not print converted 3' dangle energies and enthalpies
  
 help description.  */
  int without_Misc_flag;	/**< @brief Do not print converted Misc energies and enthalpies (TerminalAU, DuplexInit, lxc)
  
 (default=off).  */
  const char *without_Misc_help; /**< @brief Do not print converted Misc energies and enthalpies (TerminalAU, DuplexInit, lxc)
  
 help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int output_given ;	/**< @brief Whether output was given.  */
  unsigned int input_given ;	/**< @brief Whether input was given.  */
  unsigned int vanilla_given ;	/**< @brief Whether vanilla was given.  */
  unsigned int dump_given ;	/**< @brief Whether dump was given.  */
  unsigned int silent_given ;	/**< @brief Whether silent was given.  */
  unsigned int without_HairpinE_given ;	/**< @brief Whether without-HairpinE was given.  */
  unsigned int without_StackE_given ;	/**< @brief Whether without-StackE was given.  */
  unsigned int without_IntE_given ;	/**< @brief Whether without-IntE was given.  */
  unsigned int without_BulgeE_given ;	/**< @brief Whether without-BulgeE was given.  */
  unsigned int without_MultiE_given ;	/**< @brief Whether without-MultiE was given.  */
  unsigned int without_MismatchE_given ;	/**< @brief Whether without-MismatchE was given.  */
  unsigned int without_MismatchH_given ;	/**< @brief Whether without-MismatchH was given.  */
  unsigned int without_MismatchI_given ;	/**< @brief Whether without-MismatchI was given.  */
  unsigned int without_MismatchM_given ;	/**< @brief Whether without-MismatchM was given.  */
  unsigned int without_Dangle5_given ;	/**< @brief Whether without-Dangle5 was given.  */
  unsigned int without_Dangle3_given ;	/**< @brief Whether without-Dangle3 was given.  */
  unsigned int without_Misc_given ;	/**< @brief Whether without-Misc was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAparconv_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAparconv_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAparconv_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAparconv_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAparconv_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAparconv_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAparconv_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *RNAparconv_args_info_full_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAparconv_cmdline_parser (int argc, char **argv,
  struct RNAparconv_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAparconv_cmdline_parser_ext() instead
 */
int RNAparconv_cmdline_parser2 (int argc, char **argv,
  struct RNAparconv_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAparconv_cmdline_parser_ext (int argc, char **argv,
  struct RNAparconv_args_info *args_info,
  struct RNAparconv_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAparconv_cmdline_parser_dump(FILE *outfile,
  struct RNAparconv_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAparconv_cmdline_parser_file_save(const char *filename,
  struct RNAparconv_args_info *args_info);

/**
 * Print the help
 */
void RNAparconv_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void RNAparconv_cmdline_parser_print_full_help(void);
/**
 * Print the version
 */
void RNAparconv_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAparconv_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAparconv_cmdline_parser_params_init(struct RNAparconv_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAparconv_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAparconv_cmdline_parser_params structure
 */
struct RNAparconv_cmdline_parser_params *RNAparconv_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAparconv_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAparconv_cmdline_parser_init (struct RNAparconv_args_info *args_info);
/**
 * Deallocates the string fields of the RNAparconv_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAparconv_cmdline_parser_free (struct RNAparconv_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAparconv_cmdline_parser_required (struct RNAparconv_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNAPARCONV_CMDL_H */
