/* camellia_asm.S ver 1.1
 *
 * Copyright © 2012-2013 Jussi Kivilinna <jussi.kivilinna@iki.fi>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

 /* Adapted to VeraCrypt
   - original file pre-processed using "gcc -E"
   - added instructions at begining of each functiont to adapt to Windows parameters passing convention
   - Fix "'ADDR32' relocation" error when building Windows driver by using lea to load address of tables into
     registers instead of using immediat form in xorq. This required saving many registers in the stack in order
	 to free 7 general purpose registers %r9-%r15 and %xmm0/%xmm1 are used for the 8th table: %xmm0 stores table
	 address and %xmm1 is used to save/restore %r8 each time it is used for memory addressed by %xmm0.
	 These changes reduce performance compared to original code by around 8%.
	 Original code did not have 'ADDR32' relocation issue because it was implemented as an executable, not a shared 
	 library like the case of Windows driver.

 */ 

.text

.extern camellia_sp10011110;
.extern camellia_sp22000222;
.extern camellia_sp03303033;
.extern camellia_sp00444404;
.extern camellia_sp02220222;
.extern camellia_sp30333033;
.extern camellia_sp44044404;
.extern camellia_sp11101110;

.align 8
.global camellia_encrypt_asm;
.global _camellia_encrypt_asm;

camellia_encrypt_asm:
_camellia_encrypt_asm:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif

pushq %r12
pushq %r13
pushq %r14
pushq %r15

leaq camellia_sp10011110(%rip), %r12
leaq camellia_sp22000222(%rip), %r13
leaq camellia_sp03303033(%rip), %r14
leaq camellia_sp00444404(%rip), %r15
leaq camellia_sp02220222(%rip), %r9
leaq camellia_sp30333033(%rip), %r10
leaq camellia_sp44044404(%rip), %r11
leaq camellia_sp11101110(%rip), %rax
movq %rax, %xmm0
                                          
 pushq %rbp

 pushq %rsi
 movq %rdx, %rsi;

 movq (%rsi), %rax; bswapq %rax; rolq $32, %rax; movq 4*2(%rsi), %rcx; bswapq %rcx; rorq $32, %rcx; xorq 0(%rdi), %rax;;

 movq (0 + ((0 + 2) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((0 + 3) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((0 + 4) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((0 + 5) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((0 + 6) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((0 + 7) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl (0 + ((8 + 0) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((8 + 1) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movq (0 + ((8 + 0) * 2) * 4)(%rdi), %r8; orq %rax, %r8; shrq $32, %r8; xorq %r8, %rax; movl (0 + ((8 + 1) * 2) * 4)(%rdi), %esi; andl %ecx, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rcx;;;
 movq (0 + ((8 + 2) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((8 + 3) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((8 + 4) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((8 + 5) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((8 + 6) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((8 + 7) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl (0 + ((16 + 0) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((16 + 1) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movq (0 + ((16 + 0) * 2) * 4)(%rdi), %r8; orq %rax, %r8; shrq $32, %r8; xorq %r8, %rax; movl (0 + ((16 + 1) * 2) * 4)(%rdi), %esi; andl %ecx, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rcx;;;
 movq (0 + ((16 + 2) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((16 + 3) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((16 + 4) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((16 + 5) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((16 + 6) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((16 + 7) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl $24, %ebp;

 movl (0 + ((24 + 0) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((24 + 1) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movq (0 + ((24 + 0) * 2) * 4)(%rdi), %r8; orq %rax, %r8; shrq $32, %r8; xorq %r8, %rax; movl (0 + ((24 + 1) * 2) * 4)(%rdi), %esi; andl %ecx, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rcx;;;
 movq (0 + ((24 + 2) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((24 + 3) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((24 + 4) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((24 + 5) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((24 + 6) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((24 + 7) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl $32, %ebp;

__enc_done:
 popq %rsi

 xorq 0(%rdi, %rbp, 8), %rcx; rorq $32, %rcx; bswapq %rcx; movq %rcx, (%rsi); rolq $32, %rax; bswapq %rax; movq %rax, 4*2(%rsi);;

 popq %rbp

popq %r15
popq %r14
popq %r13
popq %r12

.ifdef WINABI
popq %rdi
popq %rsi
.endif

 ret;

.align 8
.global camellia_decrypt_asm;
.global _camellia_decrypt_asm;

camellia_decrypt_asm:
_camellia_decrypt_asm:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif

pushq %r12
pushq %r13
pushq %r14
pushq %r15



leaq camellia_sp10011110(%rip), %r12
leaq camellia_sp22000222(%rip), %r13
leaq camellia_sp03303033(%rip), %r14
leaq camellia_sp00444404(%rip), %r15
leaq camellia_sp02220222(%rip), %r9
leaq camellia_sp30333033(%rip), %r10
leaq camellia_sp44044404(%rip), %r11
leaq camellia_sp11101110(%rip), %rax
movq %rax, %xmm0

 pushq %rbp
 pushq %rsi
 movq %rdx, %rsi;

 movq (%rsi), %rax; bswapq %rax; rolq $32, %rax; movq 4*2(%rsi), %rcx; bswapq %rcx; rorq $32, %rcx; xorq 256(%rdi), %rax;;

 movq (0 + ((24 + 7) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((24 + 6) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((24 + 5) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((24 + 4) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((24 + 3) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((24 + 2) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl (0 + ((24 + 1) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((24 + 0) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movq (0 + ((24 + 1) * 2) * 4)(%rdi), %r8; orq %rax, %r8; shrq $32, %r8; xorq %r8, %rax; movl (0 + ((24 + 0) * 2) * 4)(%rdi), %esi; andl %ecx, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rcx;;;

__dec_rounds16:
 movq (0 + ((16 + 7) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((16 + 6) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((16 + 5) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((16 + 4) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((16 + 3) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((16 + 2) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl (0 + ((16 + 1) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((16 + 0) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movq (0 + ((16 + 1) * 2) * 4)(%rdi), %r8; orq %rax, %r8; shrq $32, %r8; xorq %r8, %rax; movl (0 + ((16 + 0) * 2) * 4)(%rdi), %esi; andl %ecx, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rcx;;;
 movq (0 + ((8 + 7) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((8 + 6) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((8 + 5) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((8 + 4) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((8 + 3) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((8 + 2) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;
 movl (0 + ((8 + 1) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((8 + 0) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movq (0 + ((8 + 1) * 2) * 4)(%rdi), %r8; orq %rax, %r8; shrq $32, %r8; xorq %r8, %rax; movl (0 + ((8 + 0) * 2) * 4)(%rdi), %esi; andl %ecx, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rcx;;;
 movq (0 + ((0 + 7) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((0 + 6) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((0 + 5) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((0 + 4) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;; movq (0 + ((0 + 3) * 2) * 4)(%rdi), %r8; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rcx;;; movq (0 + ((0 + 2) * 2) * 4)(%rdi), %r8; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; xorq %r8, %rax;;;;

 popq %rsi

 xorq 0(%rdi), %rcx; rorq $32, %rcx; bswapq %rcx; movq %rcx, (%rsi); rolq $32, %rax; bswapq %rax; movq %rax, 4*2(%rsi);;

 popq %rbp

 popq %r15
popq %r14
popq %r13
popq %r12

 .ifdef WINABI
popq %rdi
popq %rsi
.endif

 ret;

.align 8
.global camellia_enc_blk2
.global _camellia_enc_blk2

camellia_enc_blk2:
_camellia_enc_blk2:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif

pushq %r12
pushq %r13
pushq %r14
pushq %r15

leaq camellia_sp10011110(%rip), %r12
leaq camellia_sp22000222(%rip), %r13
leaq camellia_sp03303033(%rip), %r14
leaq camellia_sp00444404(%rip), %r15
leaq camellia_sp02220222(%rip), %r9
leaq camellia_sp30333033(%rip), %r10
leaq camellia_sp44044404(%rip), %r11
leaq camellia_sp11101110(%rip), %rax
movq %rax, %xmm0


 pushq %rbx;

 pushq %rbp
 pushq %rsi
 movq %rdx, %rsi;

 movq (%rsi), %rax; bswapq %rax; rorq $32, %rax; movq 4*2(%rsi), %rcx; bswapq %rcx; rolq $32, %rcx; xorq 0(%rdi), %rax; movq 8*2(%rsi), %rbx; bswapq %rbx; rorq $32, %rbx; movq 12*2(%rsi), %rdx; bswapq %rdx; rolq $32, %rdx; xorq 0(%rdi), %rbx;;

 movq (0 + ((0 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((0 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((0 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((0 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((0 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((0 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl (0 + ((8 + 0) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((8 + 1) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movl (0 + ((8 + 0) * 2) * 4)(%rdi), %r8d; andl %ebx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rbx; movq (0 + ((8 + 1) * 2) * 4)(%rdi), %rsi; orq %rdx, %rsi; shrq $32, %rsi; xorq %rsi, %rdx; movq (0 + ((8 + 0) * 2) * 4)(%rdi), %rbp; orq %rax, %rbp; shrq $32, %rbp; xorq %rbp, %rax; movl (0 + ((8 + 1) * 2) * 4)(%rdi), %r8d; andl %ecx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rcx; movq (0 + ((8 + 0) * 2) * 4)(%rdi), %rsi; orq %rbx, %rsi; shrq $32, %rsi; xorq %rsi, %rbx; movl (0 + ((8 + 1) * 2) * 4)(%rdi), %ebp; andl %edx, %ebp; roll $1, %ebp; shlq $32, %rbp; xorq %rbp, %rdx;;;
 movq (0 + ((8 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((8 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((8 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((8 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((8 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((8 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl (0 + ((16 + 0) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((16 + 1) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movl (0 + ((16 + 0) * 2) * 4)(%rdi), %r8d; andl %ebx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rbx; movq (0 + ((16 + 1) * 2) * 4)(%rdi), %rsi; orq %rdx, %rsi; shrq $32, %rsi; xorq %rsi, %rdx; movq (0 + ((16 + 0) * 2) * 4)(%rdi), %rbp; orq %rax, %rbp; shrq $32, %rbp; xorq %rbp, %rax; movl (0 + ((16 + 1) * 2) * 4)(%rdi), %r8d; andl %ecx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rcx; movq (0 + ((16 + 0) * 2) * 4)(%rdi), %rsi; orq %rbx, %rsi; shrq $32, %rsi; xorq %rsi, %rbx; movl (0 + ((16 + 1) * 2) * 4)(%rdi), %ebp; andl %edx, %ebp; roll $1, %ebp; shlq $32, %rbp; xorq %rbp, %rdx;;;
 movq (0 + ((16 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((16 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((16 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((16 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((16 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((16 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl $24, %r8d;

 movl (0 + ((24 + 0) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((24 + 1) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movl (0 + ((24 + 0) * 2) * 4)(%rdi), %r8d; andl %ebx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rbx; movq (0 + ((24 + 1) * 2) * 4)(%rdi), %rsi; orq %rdx, %rsi; shrq $32, %rsi; xorq %rsi, %rdx; movq (0 + ((24 + 0) * 2) * 4)(%rdi), %rbp; orq %rax, %rbp; shrq $32, %rbp; xorq %rbp, %rax; movl (0 + ((24 + 1) * 2) * 4)(%rdi), %r8d; andl %ecx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rcx; movq (0 + ((24 + 0) * 2) * 4)(%rdi), %rsi; orq %rbx, %rsi; shrq $32, %rsi; xorq %rsi, %rbx; movl (0 + ((24 + 1) * 2) * 4)(%rdi), %ebp; andl %edx, %ebp; roll $1, %ebp; shlq $32, %rbp; xorq %rbp, %rdx;;;
 movq (0 + ((24 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((24 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((24 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((24 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((24 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((24 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl $32, %r8d;

__enc2_done:
 popq %rsi

 xorq 0(%rdi, %r8, 8), %rcx; rolq $32, %rcx; bswapq %rcx; movq %rcx, (%rsi); rorq $32, %rax; bswapq %rax; movq %rax, 4*2(%rsi); xorq 0(%rdi, %r8, 8), %rdx; rolq $32, %rdx; bswapq %rdx; movq %rdx, 8*2(%rsi); rorq $32, %rbx; bswapq %rbx; movq %rbx, 12*2(%rsi);;

 popq %rbp
 popq %rbx;

 popq %r15
popq %r14
popq %r13
popq %r12
 
 .ifdef WINABI
popq %rdi
popq %rsi
.endif

 ret;

.align 8
.global camellia_dec_blk2
.global _camellia_dec_blk2

camellia_dec_blk2:
_camellia_dec_blk2:

.ifdef WINABI
pushq %rsi
pushq %rdi
movq %rcx, %rdi;
movq %rdx, %rsi;
movq %r8, %rdx;
.endif

pushq %r12
pushq %r13
pushq %r14
pushq %r15

leaq camellia_sp10011110(%rip), %r12
leaq camellia_sp22000222(%rip), %r13
leaq camellia_sp03303033(%rip), %r14
leaq camellia_sp00444404(%rip), %r15
leaq camellia_sp02220222(%rip), %r9
leaq camellia_sp30333033(%rip), %r10
leaq camellia_sp44044404(%rip), %r11
leaq camellia_sp11101110(%rip), %rax
movq %rax, %xmm0

 pushq %rbx

 pushq %rbp
 pushq %rsi
 movq %rdx, %rsi;

 movq (%rsi), %rax; bswapq %rax; rorq $32, %rax; movq 4*2(%rsi), %rcx; bswapq %rcx; rolq $32, %rcx; xorq 256(%rdi), %rax; movq 8*2(%rsi), %rbx; bswapq %rbx; rorq $32, %rbx; movq 12*2(%rsi), %rdx; bswapq %rdx; rolq $32, %rdx; xorq 256(%rdi), %rbx;;

 movq (0 + ((24 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((24 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((24 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((24 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((24 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((24 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl (0 + ((24 + 1) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((24 + 0) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movl (0 + ((24 + 1) * 2) * 4)(%rdi), %r8d; andl %ebx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rbx; movq (0 + ((24 + 0) * 2) * 4)(%rdi), %rsi; orq %rdx, %rsi; shrq $32, %rsi; xorq %rsi, %rdx; movq (0 + ((24 + 1) * 2) * 4)(%rdi), %rbp; orq %rax, %rbp; shrq $32, %rbp; xorq %rbp, %rax; movl (0 + ((24 + 0) * 2) * 4)(%rdi), %r8d; andl %ecx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rcx; movq (0 + ((24 + 1) * 2) * 4)(%rdi), %rsi; orq %rbx, %rsi; shrq $32, %rsi; xorq %rsi, %rbx; movl (0 + ((24 + 0) * 2) * 4)(%rdi), %ebp; andl %edx, %ebp; roll $1, %ebp; shlq $32, %rbp; xorq %rbp, %rdx;;;

__dec2_rounds16:
 movq (0 + ((16 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((16 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((16 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((16 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((16 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((16 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl (0 + ((16 + 1) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((16 + 0) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movl (0 + ((16 + 1) * 2) * 4)(%rdi), %r8d; andl %ebx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rbx; movq (0 + ((16 + 0) * 2) * 4)(%rdi), %rsi; orq %rdx, %rsi; shrq $32, %rsi; xorq %rsi, %rdx; movq (0 + ((16 + 1) * 2) * 4)(%rdi), %rbp; orq %rax, %rbp; shrq $32, %rbp; xorq %rbp, %rax; movl (0 + ((16 + 0) * 2) * 4)(%rdi), %r8d; andl %ecx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rcx; movq (0 + ((16 + 1) * 2) * 4)(%rdi), %rsi; orq %rbx, %rsi; shrq $32, %rsi; xorq %rsi, %rbx; movl (0 + ((16 + 0) * 2) * 4)(%rdi), %ebp; andl %edx, %ebp; roll $1, %ebp; shlq $32, %rbp; xorq %rbp, %rdx;;;
 movq (0 + ((8 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((8 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((8 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((8 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((8 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((8 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;
 movl (0 + ((8 + 1) * 2) * 4)(%rdi), %esi; andl %eax, %esi; roll $1, %esi; shlq $32, %rsi; xorq %rsi, %rax; movq (0 + ((8 + 0) * 2) * 4)(%rdi), %rbp; orq %rcx, %rbp; shrq $32, %rbp; xorq %rbp, %rcx; movl (0 + ((8 + 1) * 2) * 4)(%rdi), %r8d; andl %ebx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rbx; movq (0 + ((8 + 0) * 2) * 4)(%rdi), %rsi; orq %rdx, %rsi; shrq $32, %rsi; xorq %rsi, %rdx; movq (0 + ((8 + 1) * 2) * 4)(%rdi), %rbp; orq %rax, %rbp; shrq $32, %rbp; xorq %rbp, %rax; movl (0 + ((8 + 0) * 2) * 4)(%rdi), %r8d; andl %ecx, %r8d; roll $1, %r8d; shlq $32, %r8; xorq %r8, %rcx; movq (0 + ((8 + 1) * 2) * 4)(%rdi), %rsi; orq %rbx, %rsi; shrq $32, %rsi; xorq %rsi, %rbx; movl (0 + ((8 + 0) * 2) * 4)(%rdi), %ebp; andl %edx, %ebp; roll $1, %ebp; shlq $32, %rbp; xorq %rbp, %rdx;;;
 movq (0 + ((0 + 7) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((0 + 6) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((0 + 5) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((0 + 4) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;; movq (0 + ((0 + 3) * 2) * 4)(%rdi), %r8; xorq %r8, %rdx; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r15, %rbp, 8), %rcx; xorq (%r14, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rcx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rcx;; movzbl %al, %ebp; movzbl %ah, %esi; rorq $16, %rax; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r15, %rbp, 8), %rdx; xorq (%r14, %rsi, 8), %rdx;; xorq %r8, %rcx; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r13, %rbp, 8), %rdx; xorq (%r12, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rdx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rdx;; movzbl %bl, %ebp; movzbl %bh, %esi; rorq $16, %rbx; xorq (%r10, %rbp, 8), %rdx; xorq (%r9, %rsi, 8), %rdx;;;; movq (0 + ((0 + 2) * 2) * 4)(%rdi), %r8; xorq %r8, %rbx; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r15, %rbp, 8), %rax; xorq (%r14, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r13, %rbp, 8), %r8; xorq (%r12, %rsi, 8), %r8;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rax; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rax;; movzbl %cl, %ebp; movzbl %ch, %esi; rorq $16, %rcx; xorq (%r10, %rbp, 8), %r8; xorq (%r9, %rsi, 8), %r8;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r15, %rbp, 8), %rbx; xorq (%r14, %rsi, 8), %rbx;; xorq %r8, %rax; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r13, %rbp, 8), %rbx; xorq (%r12, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; movq %r8, %xmm1; movq %xmm0, %r8; xorq (%r8, %rbp, 8), %rbx; movq %xmm1, %r8; xorq (%r11, %rsi, 8), %rbx;; movzbl %dl, %ebp; movzbl %dh, %esi; rorq $16, %rdx; xorq (%r10, %rbp, 8), %rbx; xorq (%r9, %rsi, 8), %rbx;;;;;

 popq %rsi

 xorq 0(%rdi), %rcx; rolq $32, %rcx; bswapq %rcx; movq %rcx, (%rsi); rorq $32, %rax; bswapq %rax; movq %rax, 4*2(%rsi); xorq 0(%rdi), %rdx; rolq $32, %rdx; bswapq %rdx; movq %rdx, 8*2(%rsi); rorq $32, %rbx; bswapq %rbx; movq %rbx, 12*2(%rsi);;

 popq %rbp
 
 popq %rbx;

 popq %r15
popq %r14
popq %r13
popq %r12

 .ifdef WINABI
popq %rdi
popq %rsi
.endif

 ret;

 .ifndef __YASM__
#if defined(__linux__) && defined(__ELF__)
.section .note.GNU-stack,"",%progbits
#endif
 .endif

