/*
HMDOMRSS.h

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMDOMRSS.h"

@implementation HMRSSNodeFilter

//--------------------------------------------------------------//
#pragma mark -- RSS MIME types --
//--------------------------------------------------------------//

+ (NSArray*)RSSMimes
{
    static NSArray* _RSSMimes = nil;
    if (!_RSSMimes) {
        _RSSMimes = [[NSArray arrayWithObjects:
                @"text/xml", 
                @"application/xml", 
                @"application/xhtml+xml", 
                @"application/rss+xml", 
                @"application/rdf+xml", 
                @"application/atom+xml", 
                nil] retain];
    }
    
    return _RSSMimes;
}

//--------------------------------------------------------------//
#pragma mark -- DOMNodeFilter protocol --
//--------------------------------------------------------------//

- (short)acceptNode:(DOMNode*)node
{
    // Check node class
    if (![node isKindOfClass:[DOMHTMLLinkElement class]]) {
        return DOM_FILTER_SKIP;
    }
    
    DOMHTMLLinkElement* link;
    link = (DOMHTMLLinkElement*)node;
    
    // Check type
    NSString*   type;
    type = [link type];
    if (![[[self class] RSSMimes] containsObject:type]) {
        return DOM_FILTER_SKIP;
    }
    
    return DOM_FILTER_ACCEPT;
}

@end

#pragma mark -

@implementation WebView (rss)

//--------------------------------------------------------------//
#pragma mark -- RSS --
//--------------------------------------------------------------//

- (BOOL)hasRSSLink
{
    // Get DOM document
    DOMDocument*    domDocument;
    domDocument = [[self mainFrame] DOMDocument];
    if (!domDocument) {
        return NO;
    }
    
    // Find RSS node
    HMRSSNodeFilter*    filter;
    DOMNodeIterator*    iterator;
    filter = [[HMRSSNodeFilter alloc] init];
    [filter autorelease];
    iterator = [domDocument createNodeIterator:[domDocument documentElement] 
            :DOM_SHOW_ELEMENT :filter :NO];
    
    return [iterator nextNode] != nil;
}

- (NSArray*)RSSLinks
{
    NSMutableArray* links;
    links = [NSMutableArray array];
    
    // Get DOM document
    DOMDocument*    domDocument;
    domDocument = [[self mainFrame] DOMDocument];
    if (!domDocument) {
        return links;
    }
    
    // Find RSS node
    HMRSSNodeFilter*    filter;
    DOMNodeIterator*    iterator;
    DOMHTMLLinkElement* link;
    filter = [[HMRSSNodeFilter alloc] init];
    [filter autorelease];
    iterator = [domDocument createNodeIterator:[domDocument documentElement] 
            :DOM_SHOW_ELEMENT :filter :NO];
    while (link = (DOMHTMLLinkElement*)[iterator nextNode]) {
        // Get href
        NSString*   href;
        href = [link href];
        if (!href || [href length] == 0) {
            continue;
        }
        
        // Add href
        [links addObject:href];
    }
    
    return links;
}

@end
