/*
HMMD5.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import <openssl/md5.h>

#import "HMMD5.h"

//--------------------------------------------------------------//
#pragma mark -- MD5 --
//--------------------------------------------------------------//

NSString* HMCreateMD5String(
        NSString* string)
{
    // Calc MD5
    MD5_CTX         md5;
    const char*     data;
    unsigned char   md[16];
    data = [string cString];
    MD5_Init(&md5);
    MD5_Update(&md5, data, strlen(data));
    MD5_Final(md, &md5);
    
    // Convert to string
    NSMutableString*    md5String;
    md5String = [NSMutableString string];
    
    int i;
    for (i = 0; i < 16; i++) {
        [md5String appendFormat:@"%02x", md[i]];
    }
    return md5String;
}

NSString* HMCreateMD5StringWithFile(
        NSString* filePath)
{
    return HMCreateMD5StringWithFileLength(filePath, 1024);
}

NSString* HMCreateMD5StringWithFileLength(
        NSString* filePath, 
        unsigned int length)
{
    // Check file
    if (![[NSFileManager defaultManager] fileExistsAtPath:filePath]) {
        return nil;
    }
    
    // Create data
    NSData* data;
    data = [NSData dataWithContentsOfFile:filePath];
    if (!data) {
        return nil;
    }
    
    // Check length
    if (length > [data length]) {
        length = [data length];
    }
    
    // Get MD5 value
    MD5_CTX         md5;
    unsigned char   value[16];
    MD5_Init(&md5);
    MD5_Update(&md5, [data bytes], length);
    MD5_Final(value, &md5);
    
    // Convert value to string
    NSMutableString*    string;
    string = [NSMutableString string];
    
    int i;
    for (i = 0; i < 16; i++) {
        [string appendFormat:@"%02x", value[i]];
    }
    
    return string;
}
