//
//  HMInfoBar.h
//  HMInfoBar
//
//  Created by MIURA Kazki on 10.04.06.
//  Copyright 2006 MIURA Kazki. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <HMDTFoundation/HMDTFoundation.h>

#import "HMInfoBarButton.h"
#import "HMMenuButton.h"


@interface HMInfoBar : NSView
{
	NSMutableArray *_buttons;
	float _marginX;
	HMInfoBarButton *_selectedButton;
	NSColor *_bottomLineColor;
	
	HMMenuButton *_clipButton;
	
	unsigned _clipButtonIndex;		// buttons which index is less than _clipButtonIndex are visible
}

// Selection
- (HMInfoBarButton*)selectedButton;
- (void)selectButton:(HMInfoBarButton*)button;		// When you receive button's action, call selectButton with the button
- (void)selectButtonAtIndex:(unsigned)index;
- (void)selectButtonWithTag:(int)tag;

// Finding
- (NSArray*)buttons;
- (NSArray*)visibleButtons;
- (NSArray*)clippedButtons;
- (HMInfoBarButton*)buttonAtIndex:(unsigned)index;
- (HMInfoBarButton*)buttonWithTag:(int)tag;

// Laying out the HMInfoBar
- (void)setButtons:(NSArray*)buttons;
- (void)addButton:(HMInfoBarButton*)button;
- (void)addButtons:(NSArray*)buttons;
- (void)insertButton:(HMInfoBarButton*)button atIndex:(int)index;
- (void)removeButton:(HMInfoBarButton*)button;
- (void)removeAllButtons;
- (void)updateButtonsLayout;		// Call updateButtonsLayout method after modifying buttons and/or marginX

// Appearance
- (NSColor*)bottomLineColor;
- (void)setBottomLineColor:(NSColor*)color;
- (float)marginX;
- (void)setMarginX:(float)marginX;

@end
