/*
HMParabolaViewAnimation.m

Author: Makoto Kinoshita

Copyright 2004-2006 The Shiira Project. All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted 
provided that the following conditions are met:

  1. Redistributions of source code must retain the above copyright notice, this list of conditions 
  and the following disclaimer.

  2. Redistributions in binary form must reproduce the above copyright notice, this list of 
  conditions and the following disclaimer in the documentation and/or other materials provided 
  with the distribution.

THIS SOFTWARE IS PROVIDED BY THE SHIIRA PROJECT ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, 
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE SHIIRA PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
POSSIBILITY OF SUCH DAMAGE.
*/

#import "HMParabolaViewAnimation.h"

@implementation HMParabolaViewAnimation

//--------------------------------------------------------------//
#pragma mark -- Parabola type --
//--------------------------------------------------------------//

- (HMParabolaType)parabolaType
{
    return _parabolaType;
}

- (void)setParabolaType:(HMParabolaType)parabolaType
{
    _parabolaType = parabolaType;
}

//--------------------------------------------------------------//
#pragma mark -- Animation value --
//--------------------------------------------------------------//

- (float)currentValue
{
    return _currentValue;
}

- (void)setCurrentProgress:(NSAnimationProgress)progress
{
    // Throw up
    if (_parabolaType == HMParabolaThrowUp) {
        // y = - (x-1)^2 + 1
        float   value;
        value = progress - 1;
        value = value * value;
        _currentValue = -1 * value + 1;
    }
    
    // Fall down
    if (_parabolaType == HMParabolaFallDown) {
        // y = x^2
        _currentValue = progress * progress;
    }
    
    // Invole suerp
    [super setCurrentProgress:progress];
}

@end
