% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galaxy.R
\name{galaxy}
\alias{galaxy}
\title{Galaxy Plot: A New Visualization Tool of Bivariate Meta-Analysis Studies}
\usage{
galaxy(data, y1, s1, y2, s2, scale1, scale2, scale.adj, 
              corr, group, study.label, annotate, xlab, ylab, main, legend.pos)
}
\arguments{
\item{data}{dataset with at least 4 columns for the effect sizes of the two outcomes and their standard errors}

\item{y1}{column name for outcome 1, default is 'y1'}

\item{s1}{column name for standard error of \code{y1}, default is 's1'}

\item{y2}{column name for outcome 2, default is 'y2'}

\item{s2}{column name for standard error of \code{y2}, default is 's2'}

\item{scale1}{parameter for the length of the cross hair: the ellipse width is scale1 / s1 * scale.adj}

\item{scale2}{parameter for the length of the cross hair: the ellipse height is scale2 / s2 * scale.adj}

\item{scale.adj}{a pre-specified parameter to adjust for \code{scale1} and \code{scale2}}

\item{corr}{column name for within-study correlation}

\item{group}{column name for study group}

\item{study.label}{column name for study label}

\item{annotate}{logical specifying whether study label should be added to the plot, default is FALSE.}

\item{xlab}{x axis label, default \code{y1}}

\item{ylab}{y axis label, default \code{y2}}

\item{main}{main title}

\item{legend.pos}{The position of the legend for study groups if \code{group} is specified, see \code{legend}, default is 'bottomright'.}
}
\description{
A new visualization method that simultaneously presents the effect sizes of bivariate outcomes and their standard errors in a two-dimensional space.
}
\details{
This function returns the galaxy plot to visualize bivariate meta-analysis data, 
which faithfully retains the information in two separate funnel plots, while providing 
useful insights into outcome correlations, between-study heterogeneity and joint asymmetry. 
Galaxy plot: a new visualization tool of bivariate meta-analysis studies.
Funnel plots have been widely used to detect small study effects in the results of 
univariate meta-analyses. However, there is no existing visualization tool that is 
the counterpart of the funnel plot in the multivariate setting. We propose a new 
visualization method, the galaxy plot, which can simultaneously present the effect sizes 
of bivariate outcomes and their standard errors in a two-dimensional space. 
The galaxy plot is an intuitive visualization tool that can aid in interpretation 
of results of multivariate meta-analysis. It preserves all of the information presented 
by separate funnel plots for each outcome while elucidating more complex features that 
may only be revealed by examining the joint distribution of the bivariate outcomes.
}
\examples{
data(sim_dat)
galaxy(data=sim_dat, scale.adj = 0.9, corr = 'corr', group = 'subgroup', 
        study.label = 'study.id', annotate = TRUE, main = 'galaxy plot')

}
\references{
Hong, C., Duan, R., Zeng, L., Hubbard, R., Lumley, T., Riley, R., Chu, H., Kimmel, S., and Chen, Y. (2020) 
Galaxy Plot: A New Visualization Tool of Bivariate Meta-Analysis Studies, American Journal of Epidemiology, https://doi.org/10.1093/aje/kwz286.
}
\author{
Chuan Hong, Chongliang Luo, Yong Chen
}
