% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implied_by.R
\name{is_implied_by}
\alias{is_implied_by}
\title{Find which rule(s) make rule_name redundant}
\usage{
is_implied_by(x, rule_name, ...)
}
\arguments{
\item{x}{\code{\link{validator}} object with rule}

\item{rule_name}{\code{character} with the names of the rules to be checked}

\item{...}{not used}
}
\value{
\code{character} with the names of the rule that cause the implication.
}
\description{
Find out which rules are causing rule_name(s) to be redundant.
}
\examples{
rules <- validator( rule1 = x > 1
                  , rule2 = x > 2
                  )

# rule1 is superfluous
remove_redundancy(rules)

# rule 1 is implied by rule 2
is_implied_by(rules, "rule1")

rules <- validator( rule1 = x > 2
                  , rule2 = x > 2
)

# standout: rule1 and rule2, oldest rules wins
remove_redundancy(rules)

# Note that detection signifies both rules!
detect_redundancy(rules)


}
\seealso{
Other redundancy: 
\code{\link{detect_fixed_variables}()},
\code{\link{detect_redundancy}()},
\code{\link{remove_redundancy}()},
\code{\link{simplify_fixed_variables}()},
\code{\link{simplify_rules}()}
}
\concept{redundancy}
