% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{add_vector_to_df}
\alias{add_vector_to_df}
\title{Add vector to a (n x 2) data frame}
\usage{
add_vector_to_df(df, vec)
}
\arguments{
\item{df}{\code{data.frame}, with n rows and 2 columns}

\item{vec}{a vector}
}
\value{
a \code{data.frame} with additional rows and each element as a
character.
}
\description{
Given a vector, adds each value and its corresponding name to a data frame
of 2 columns as new rows, where the name fills in the 1st column and the
value the 2nd column.
}
\examples{
df = data.frame(c(0,0,1), c(0,0,2))
vec = 1:3
names(vec) = c("a","b","c")

add_vector_to_df(df, vec)

}
