% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sarmacopula.R
\docType{class}
\name{sarmacopula-class}
\alias{sarmacopula-class}
\alias{coef,sarmacopula-method}
\alias{show,sarmacopula-method}
\alias{sim,sarmacopula-method}
\alias{kendall,sarmacopula-method}
\alias{predict,sarmacopula-method}
\title{SARMA copula processes}
\usage{
\S4method{coef}{sarmacopula}(object)

\S4method{show}{sarmacopula}(object)

\S4method{sim}{sarmacopula}(object, n = 1000)

\S4method{kendall}{sarmacopula}(object, lagmax = 20)

\S4method{predict}{sarmacopula}(object, data, x, type = "df")
}
\arguments{
\item{object}{an object of the class.}

\item{n}{length of realization.}

\item{lagmax}{maximum value of lag.}

\item{data}{vector of past data values.}

\item{x}{vector of arguments of prediction function.}

\item{type}{type of prediction function ("df" for density, "qf" for quantile function
or "dens" for density).}
}
\description{
Class of objects for seasonal ARMA copula processes.
}
\section{Methods (by generic)}{
\itemize{
\item \code{coef(sarmacopula)}: Coef method for SARMA copula class

\item \code{show(sarmacopula)}: Show method for SARMA copula process

\item \code{sim(sarmacopula)}: Simulation method for sarmacopula class

\item \code{kendall(sarmacopula)}: Calculate Kendall's tau values for sarmacopula model

\item \code{predict(sarmacopula)}: Prediction method for sarmacopula class

}}
\section{Slots}{

\describe{
\item{\code{name}}{name of seasonal ARMA copula process.}

\item{\code{modelspec}}{vector containing number of AR, MA, SAR and SMA parameters as well
as the order D of seasonal differencing.}

\item{\code{pars}}{list consisting of vector of AR parameters named `ar`
and vector of MA parameters named `ma`, SAR parameters named `sar`
and vector of SMA parameters named `sma`.}
}}

\examples{
sim(sarma2arma(sarmacopula(list(ar = 0.5, ma = 0.4, sar = 0.2, sma = 0.6), period = 4)))
mod <- sarmacopula(list(ar = 0.5, ma = 0.4, sar = 0.2, sma = 0.6), period = 4)
kendall(mod)
}
