% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dvinecopula2.R
\name{dvinecopula2}
\alias{dvinecopula2}
\title{Constructor function for dvinecopula2 process}
\usage{
dvinecopula2(
  family = "gauss",
  rotation = 0,
  kpacf = "kpacf_arma",
  pars = list(ar = 0.1, ma = 0.1),
  maxlag = Inf,
  negtau = "none"
)
}
\arguments{
\item{family}{family name}

\item{rotation}{a scalar specifying the rotation (default is 0)}

\item{kpacf}{a character string giving the name of the Kendall pacf}

\item{pars}{a list containing the parameters of the model}

\item{maxlag}{a scalar specifying the maximum lag}

\item{negtau}{a character string specifying the treatment of negative Kendall's tau values}
}
\value{
An object of class \linkS4class{dvinecopula2}.
}
\description{
This function sets up a stationary d-vine process of finite or infinite order based on a single
copula family from a subset of those that can be implemented using
\code{\link[rvinecopulib]{bicop_dist}} in the \code{rvinecopulib} package.
}
\details{
The copula family may be any one-parameter family or the t copula family. The basic copula from
which the sequence is built may be rotated through 180 degrees using the \code{rotation} argument; the default
is no rotation (0 degrees).

The copulas are parameterized using the Kendall partial autocorrelation function (kpacf) specified
by the \code{kpacf} argument. The default choice is the kpacf of a standard ARMA process which is
implemented in the function \code{\link{kpacf_arma}}. The parameters
of the kpacf should be set as a list using the \code{pars} argument; the required parameters should usually
be clear from the documentation of the chosen kpacf function and must be correctly named.

If the kpacf takes a negative value at any lag and the standard copula is unable to model a
negative dependency (e.g. Clayton, Gumbel, Joe and their 180 degree rotations) then one of four
different treatments may be specified using the \code{negtau} parameter: "gauss" substitutes a
Gaussian copula at that lag; "frank" substitutes a Frank copula; "right" and "left" rotate the copula
through 90 degrees in a clockwise or anto-clockwise direction respectively.

The \code{maxlag} parameter specifies the maximum lag of the process; a finite number gives a finite-order
stationary d-vine process, but the parameter may also be set to \code{Inf} for an infinite-order process.

If the t copula is chosen by setting \code{family} equal to "t", the list of
parameters needs to be augmented with a component named "df" which is
the degrees of freedom. In this case it makes sense to set \code{maxlag} to be a finite number to avoid models
with tail dependencies at arbitrary lags which are not ergodic. The class \linkS4class{dvinecopula3}
is more suitable for working with t copulas with different degrees of freedom at different lags.
}
\examples{
dvinecopula2(family = "joe", kpacf = "kpacf_arma",
pars = list(ar = 0.95, ma = -0.85), maxlag = 30)
}
