% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{quoteText}
\alias{quoteText}
\title{Add single quotes to strings, useful for converting R strings into SQL formatted strings.}
\usage{
quoteText(
  x,
  char_only = TRUE,
  excluded_chars = c("NULL"),
  null_or_na_as_NULL = TRUE
)
}
\arguments{
\item{x}{A string.}

\item{char_only}{TRUE/FALSE, if TRUE, adds quotes only if is.character(x) is TRUE.}

\item{excluded_chars}{A character vector, will not add quotes if a value is in excluded_chars.}

\item{null_or_na_as_NULL}{TRUE/FALSE, if TRUE, NULL and NA values are replaced with the string "NULL".}
}
\value{
A string, with single quotes added to match PostgreSQL string formatting.
}
\description{
Add single quotes to strings, useful for converting R strings into SQL formatted strings.
}
\examples{
quoteText("Sample quotes.")
}
