% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spread_all.R
\name{spread_all}
\alias{spread_all}
\title{Spreads all scalar values of a JSON object into new columns}
\usage{
spread_all(.x, recursive = TRUE, sep = ".")
}
\arguments{
\item{.x}{a json string or \code{\link{tbl_json}} object}

\item{recursive}{whether or not to recursively spread nested objects}

\item{sep}{character used to separate nested object names when resursive
is \code{TRUE}}
}
\value{
a \code{\link{tbl_json}} object
}
\description{
Like the \code{\link[tidyr]{spread}} function in \code{tidyr} but for JSON,
this function spreads out any JSON objects that are scalars into new columns.
If objects are nested, then the recursive flag will expand scalar values of
nested objects out with a compound column name based on the sequences of
nested object names concatenated with the \code{sep} character.
}
\details{
Note that arrays are ignored by this function, use \code{\link{gather_array}}
to gather the array first, and then use \code{spread_all} if the array
contains objects or use one of the \code{\link{append_values}} functions to
capture the array values if they are scalars.

Note that scalar JSON values (e.g., a JSON string like '1') are also
ignored, as they have no names to create column names with.

The order of columns is determined by the order they are encountered in the
JSON document, with nested objects placed at the end.

If an objects have name-value pairs with names that are duplicates, then
\code{".n"} is appended for n incrementing from 2 on to ensure that columns
are unique. This also happens if \code{.x} already has a column with the
name of a name-value pair.

This function does not change the value of the JSON attribute of the
\code{\link{tbl_json}} object in any way.
}
\examples{

# A simple example
json <- c('{"a": "x", "b": 1, "c": true}',
          '{"a": "y", "c": false}',
          '{"a": null, "d": "z"}')
json \%>\% spread_all

# A more complex example
worldbank \%>\% spread_all

\dontrun{
  # Resolving duplicate column names
  json <- '{"a": "x", "a": "y"}'
  json \%>\% spread_all
}
}
\seealso{
\code{\link{spread_values}} to specific which specific values
         to spread along with their types,
         \code{\link[tidyr]{spread}} for spreading data frames
}
