% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google.R
\name{font_add_google}
\alias{font_add_google}
\alias{font.add.google}
\title{Load Google Fonts into 'sysfonts'}
\usage{
font_add_google(
  name,
  family = name,
  regular.wt = 400,
  bold.wt = 700,
  repo = "http://fonts.gstatic.com/",
  db_cache = TRUE,
  handle = curl::new_handle()
)

font.add.google(
  name,
  family = name,
  regular.wt = 400,
  bold.wt = 700,
  repo = "http://fonts.gstatic.com/",
  handle = curl::new_handle()
)
}
\arguments{
\item{name}{name of the font that will be searched in Google Fonts}

\item{family}{specifies the family name of this font in R. This can be any string,
not necessarily the same as \code{name}. The value of this parameter
will be used in R plotting functions. See the example code below.}

\item{regular.wt}{font weight for the regular font face, usually 400}

\item{bold.wt}{font weight for the bold font face, usually 700}

\item{repo}{the site that hosts the font files. Default is the official
repository \code{http://fonts.gstatic.com/} provided by
Google Fonts.}

\item{db_cache}{whether to obtain font metadata from a cache site. Using cache
is typically faster, but not as update-to-date as using the official
API. If \code{db_cache} is set to \code{FALSE}, then metadata
are retrieved from the Google Fonts API.}

\item{handle}{a curl handle object passed to \code{curl::curl_download()}.}
}
\description{
The two versions of this function are equivalent, but the
"underscore" naming is preferred.

This function will search the Google Fonts repository
(\url{https://fonts.google.com/}) for a specified
family name, download the proper font files, and then add them to \pkg{sysfonts}.
This function requires the \pkg{jsonlite} and \pkg{curl} packages.
}
\details{
There are thousands of open source fonts in the Google Fonts
         repository (\url{https://fonts.google.com/}).
         This function will try to search the font family specified
         by the \code{name} argument, and then automatically
         download the font files for all possible font faces
         ("regular", "bold", "italic" and "bold italic",
         but no"symbol").
         If fonts are found and downloaded successfully, they will be
         also added to \pkg{sysfonts} with the given family name.
}
\examples{
\dontrun{
font_add_google("Alegreya Sans", "aleg")

if(require(showtext))
{
    wd = setwd(tempdir())
    pdf("google-fonts-ex.pdf")
    showtext_begin()
    
    par(family = "aleg")
    plot(0:5,0:5, type="n")
    text(1:4, 1:4, "Alegreya Sans", font=1:4, cex = 2)
    
    showtext_end()
    dev.off()
    setwd(wd)
}

}
}
\seealso{
\code{\link{font_families_google}()}
}
\author{
Yixuan Qiu <\url{https://statr.me/}>
}
