% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{fast_lma}
\alias{fast_lma}
\alias{fast_rca}
\title{Log-Multiplicative Association Analysis}
\usage{
fast_lma(
  dat,
  k,
  weights = "marginal",
  tol = 1e-08,
  base = exp(1),
  init = "marginal"
)

fast_rca(
  dat,
  k,
  weights = "marginal",
  tol = 1e-08,
  base = exp(1),
  init = "marginal"
)
}
\arguments{
\item{dat}{Input data: can be a table or a data frame.}

\item{k}{Numeric specification of the number of latent axes to compute (i.e. k = M).}

\item{weights}{Character specification of the weights applied to standardize the coordinates: can be one of
\code{"marginal"}, \code{"uniform"}, \code{"unit"} or \code{"none"}.}

\item{tol}{Numeric specification of the convergence criterion.}

\item{base}{Numeric specification of the base with respect to which logarithms are computed.}

\item{init}{Character specification of the initialization scheme for the marginal parameters: can be either
\code{"kateri"} or \code{"marginal"}. This argument may change in future versions of the \pkg{svs} package.}
}
\value{
A list with components:
\item{\code{mar} }{A list with marginal parameters in components \code{mar1} and \code{mar2}; not so important for the analysis.}
\item{\code{val} }{The association parameters, indicating how much association each latent axis explains.}
\item{\code{pos1} }{The coordinates of the first set of levels (\emph{viz.} the row levels of a frequency table).}
\item{\code{pos2} }{The coordinates of the second set of levels (\emph{viz.} the column levels of a frequency table).}
}
\description{
A fast procedure for computing log-multiplicative analysis, i.e. Goodman's _RC(M)_ association model.
}
\details{
For now (i.e. version 3.0.0 of the \pkg{svs} package), the data frame must have only two columns.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
lma_SndT_Fra <- fast_lma(SndT_Fra, k = 7)
lma_SndT_Fra
}
\references{
Goodman, L. A. (1979) Simple models for the analysis of association in cross-classifications having ordered categories.
  \emph{Journal of the American statistical association} \strong{74} (367), 537--552.

Kateri, M. (2014) \emph{Contingency table analysis. Methods and implementation using R}. New York: Springer-Birkhauser.

Wong, R. S.-K. (2010) \emph{Association models}. Thousand Oaks: SAGE.
}
