% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relevel.R
\name{flatten_pd}
\alias{flatten_pd}
\title{Flatten a parse table}
\usage{
flatten_pd(pd_nested, token, child_token = token, left = TRUE)
}
\arguments{
\item{pd_nested}{A nested parse table.}

\item{token}{A character vector with tokens of which at least one has to
occur in \code{pd_nested} in order to flatten it.}

\item{child_token}{A character vector of tokens of which at least one has to
occur in the child in order to flatten the parse table.}

\item{left}{Flag that indicates whether the parse table should be flattened
from left or from right.}
}
\description{
Flattens a parse table if certain tokens occur in this table or its child,
either flattening from left or from right. If one of \code{token} is present in
\code{pd_nested}  and one of \code{child_token} is present in one of the children next
to \code{token} in \code{pd_nested}, the nested parse table is flattened. Otherwise, it
is returned unmodified.
}
\keyword{internal}
