% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_opts.R, R/load_toml.R, R/new_opts.R,
%   R/opts.R
\name{load_opts}
\alias{load_opts}
\alias{load_toml}
\alias{params}
\alias{new_opts}
\alias{get_opts}
\alias{set_opts}
\alias{print.opts}
\title{Setting/loading and extracting various options into the environment}
\usage{
load_opts(x, check = TRUE, envir = opts, verbose = TRUE, .parse = TRUE, ...)

load_toml(toml, .remove_period = T, envir = envir, verbose = T)

new_opts(envir = new.env())

get_opts(x, envir = opts, .use.names = FALSE)

set_opts(..., .dots, .parse = TRUE, envir = opts)

\method{print}{opts}(x, ...)
}
\arguments{
\item{x}{\itemize{
\item get_opts: a character vector of names of options to extract.
\item load_opts: path to a configuration file
}}

\item{check}{load_opts(): in case of a configuration file, whether to check if files defined in parameters exists. [TRUE]}

\item{envir}{environ used to store objects. Default is a environ object called opts [params:::opts]}

\item{verbose}{load_opts(): Logical variable indicate level of verboseness [TRUE]}

\item{.parse}{set_opts(), load_opts(): logical, whether to auto-complete \code{{{myvar}}} using previously defined options. [TRUE]}

\item{...}{set_opts(): a named set of variable/value pairs separated by comma}

\item{toml}{load_toml(): instead of a tsv, use toml to load options}

\item{.remove_period}{load_opts(): remove \\. period from option names (and replace with _)}

\item{.use.names}{get_opts(): The resulting vector should be have names (esp. if length(x) is 1). If length(x)>1, this returns a list.}

\item{.dots}{set_opts(): A named list, as a alternative to ...}
}
\description{
\itemize{
\item set_opts(): set options into a custom envir
\item get_opts(): extract options
\item load_opts(): Read a tab delimited file using \link{read_sheet} or toml file and load them as options using \link{set_opts}
\item new_opts(): create a options manager to be included in a pacakge
\item print.opts(): print pkg options as a pretty table
}
}
\details{
\strong{Integrating \link{params} in a package:}

\emph{create a options manager}:

\code{
opts_mypkg = new_opts()
}

The object \code{opts_mypkg} is a list of a few functions, which set, fetch and load
options (using a isolated environment). Here are a few examples:

\emph{Set some options}:

\code{opts_mypkg$set(version = '0.1', name = 'mypkg')}

\emph{Fetch ALL options}:

\code{opts_mypkg$get()}
OR
\code{opts_mypkg$get("version")} to fetch a specific option.


\strong{Loading configuration files}:

\code{load_opts()} OR \code{opts_pkg$load()}:


There are cases when options and params are actually paths to scripts or other apps or folders etc.
In such cases it might be useful to quickly check if these paths exists on the system.
As such, \link{load_opts}() automatically checks params ending with \code{path|dir|exe} (if check=TRUE).

For example, values for variables like \code{mypath}, \code{my_path}, \code{tool_exe}, etc would be check if they exists
and a warning would be shown if they don't exist.


Below is a list example options, retrieved via

\code{get_opts()}:

\preformatted{
|name          |value            |
|default_regex |(.*)             |
|my_conf_path  |~/flowr/conf     |
|my_dir        |path/to/a/folder |
|my_path       |~/flowr          |
|my_tool_exe   |/usr/bin/ls      |
}
}
\examples{
## Set options
opts = set_opts(flow_run_path = "~/mypath")
#OR
opts = set_opts(.dots = list(flow_run_path = "~/mypath"))

## printing options, this is internally called by get_opts()
print(opts)

## Fetch options
get_opts()
get_opts("flow_run_path")

## Load options from a file
fl = system.file("conf/params.conf", package = "params")
load_opts(fl)


## Create a options manager:
opts_mypkg = new_opts()
## this provides three functions
opts_mypkg$set(version = '0.1', name = 'mypkg')
opts_mypkg$load(fl)
opts_mypkg$get()

## Additionally, one has the options of using braces ({{}})
## do define nested options:

set_opts(first = "John", last = "Doe", full = "{{first}} {{last}}")

}
\seealso{
\link{read_sheet}

\link{read_sheet}

\link{read_sheet} \link{load_opts}
}
