#' National Longitudinal Survey of Youth data
#'
#' These data come from the years 1990-1994 in the National Longitudinal
#' Survey of Youth, with information about 581 individuals. These data are in
#' the "wide" format for demonstration purposes.
#'
#' @format A data frame with 581 rows and 16 variables:
#' \describe{
#'   \item{momage}{Mother's age at birth}
#'   \item{gender}{0 if boy, 1 if girl}
#'   \item{momwork}{1 if mother works, 0 if not)}
#'   \item{married}{1 if parents are married, 0 if not}
#'   \item{hispanic}{1 if child is Hispanic, 0 if not}
#'   \item{black}{1 if child is black, 0 if not}
#'   \item{childage}{Child's age at first interview}
#'   \item{anti90}{A measure of anti-social behavior antisocial behavior 
#'   measured on a scale from 0 to 6, taken in 1990}
#'   \item{anti92}{A measure of anti-social behavior antisocial behavior 
#'   measured on a scale from 0 to 6, taken in 1992}
#'   \item{anti94}{A measure of anti-social behavior antisocial behavior 
#'   measured on a scale from 0 to 6, taken in 1994}
#'   \item{self90}{A measure of self-esteem measured on a scale from 6 to 24,
#'   taken in 1990}
#'   \item{self92}{A measure of self-esteem measured on a scale from 6 to 24,
#'   taken in 1992}
#'   \item{self94}{A measure of self-esteem measured on a scale from 6 to 24,
#'   taken in 1994}
#'   \item{pov90}{1 if family is in poverty, 0 if not, in 1990}
#'   \item{pov92}{1 if family is in poverty, 0 if not, in 1992}
#'   \item{pov94}{1 if family is in poverty, 0 if not, in 1994}
#' }
#' @source
#'  These data originate with the U.S. Department of Labor. The particular
#'  subset used here come from Paul Allison via Statistical Horizons:
#'  \url{https://statisticalhorizons.com/wp-content/uploads/nlsy.dta}
#'
"nlsy"