% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsets.R
\name{subsets}
\alias{subsets}
\title{Generate vector subsets}
\usage{
subsets(v, n = seq_along(v))
}
\arguments{
\item{v}{A \code{vector} (\code{numeric} or \code{character}).}

\item{n}{An \code{integer} vector with the required subset sizes.
By default, \code{n = seq_along(v)}, i.e., all subsets of \code{v} are
generated.}
}
\value{
A \code{list}, each element is a subset of \code{v}.
}
\description{
This function generates subsets of a vector.
}
\examples{
v <- 1:3
subsets(v)
subsets(v, c(1, 3)) # only subsets of length 1 or 3
subsets(integer())  # trivial case works
}
