% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net_reduce.R
\name{net_reduce}
\alias{net_reduce}
\title{net_reduce}
\usage{
net_reduce(data, badpairs, method = c("PCA", "best_goldbricker"))
}
\arguments{
\item{data}{a data frame consisting of n rows (participants) and j columns (variables)}

\item{badpairs}{pairs of variables to be combined. Input may consist of:
-an object of class "goldbricker" (all bad pairs are combined)
-a vector of item names, each consecutive pair will be considered a bad pair
-a matrix with 2 columns where each bad pair takes up 1 row}

\item{method}{method for combining variables. PCA takes the first principal component of the two
variables and defines it as a new variable. best_goldbricker requires that the input of "badpairs" be an object of class
"goldbricker" it selects the more unique variable, and eliminates the other variable in the pair.}
}
\value{
\code{\link{goldbricker}} returns a dataframe of n rows (participants) and j - x columns,
where j is the number of variables in the original dataframe, and x is the number of bad pairs to reduce.
}
\description{
This function takes predefined pairs of colinear variables in a dataset and a) combines them via PCA or
b) picks the "better" variable and eliminates the other variable
}
\details{
In a given psychometric network, two nodes may be redundantly measuring the same underlying construct. If this is the case,
both variables should not appear in the same network, or network properties will be inaccurate. These variable pairs can be
reduced by combining them, or by eliminating one of them. net_reduce automates this process when given a list of "bad pairs"

If the same variable appears in multiple "bad pairs" (e.g., "x" and "y" is a bad pair, and so is "x" and "z"), only the first
of these pairs which appears in the badpairs argument will be reduced by the function.
}
\examples{
\donttest{
gb_depression <- goldbricker(depression, threshold=0.5)

reduced_depression_PCA <- net_reduce(data=depression, badpairs=gb_depression)
reduced_depression_best <- net_reduce(data=depression,
                           badpairs=gb_depression, method="best_goldbricker")

}

}
