% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relsurv.transMat.R
\name{modify_transMat}
\alias{modify_transMat}
\title{Upgrade the transMat object for the multi-state/relsurv setting.}
\usage{
modify_transMat(trans, split.transitions)
}
\arguments{
\item{trans}{The original transition matrix (usually generated using function
transMat from mstate). Also often present in the msfit object.}

\item{split.transitions}{The transitions that should be split.}
}
\value{
An upgraded transition matrix that contains the population and
excess transitions.
}
\description{
A function that upgrades the transMat object so that the population
and excess-related transitions are included in the transition matrix.
}
\examples{

# transition matrix for illness-death model
trans <- transMat(list(c(2,3),c(4), c(), c()), 
      names = c("Alive", "Relapse","Non-relapse mortality", "Death after relapse"))
split.transitions <- c(2,3)
modify_transMat(trans, split.transitions) 

}
\seealso{
\code{\link{transMat}}
}
\author{
Damjan Manevski \email{damjan.manevski@mf.uni-lj.si}
}
