% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covmat.R
\name{covmat}
\alias{covmat}
\title{construct covariate matrix (predictor matrix) in the right
format for input to the mimi or cv.mimi functions from tables of attributes
about the rows or columns of data frames.}
\usage{
covmat(n, p, R = NULL, C = NULL, E = NULL, center = T)
}
\arguments{
\item{n}{number of rows}

\item{p}{number ofcolumns}

\item{R}{nxK1 matrix of row covariates}

\item{C}{nxK2 matrix of column covariates}

\item{E}{(n+p)xK3 matrix of row-column covariates}

\item{center}{boolean indicating whether the returned covariate matrix should be centered (for identifiability)}
}
\value{
the joint product of R and C column-binded with E, a (np)x(K1+K2+K3) matrix in order row1col1,row2col1,...,rowncol1, row1col2, row2col2,...,rowncolp
}
\description{
construct covariate matrix (predictor matrix) in the right
format for input to the mimi or cv.mimi functions from tables of attributes
about the rows or columns of data frames.
}
\examples{
R <- matrix(rnorm(10), 5)
C <- matrix(rnorm(9), 3)
covs <- covmat(5,3,R,C)
}
