% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.microbenchmark}
\alias{print.microbenchmark}
\title{Print \code{microbenchmark} timings.}
\usage{
\method{print}{microbenchmark}(x, unit, order, signif, ...)
}
\arguments{
\item{x}{An object of class \code{microbenchmark}.}

\item{unit}{What unit to print the timings in. Default value taken
from to option \code{microbenchmark.unit} (see example).}

\item{order}{If present, order results according to this column of the output.}

\item{signif}{If present, limit the number of significant digits shown.}

\item{...}{Passed to \code{print.data.frame}}
}
\description{
Print \code{microbenchmark} timings.
}
\note{
The available units are nanoseconds (\code{"ns"}), microseconds
(\code{"us"}), milliseconds (\code{"ms"}), seconds (\code{"s"})
and evaluations per seconds (\code{"eps"}) and relative runtime
compared to the best median time (\code{"relative"}).

If the \code{multcomp} package is available a statistical
ranking is calculated and displayed in compact letter display from
in the \code{cld} column.
}
\examples{
a1 <- a2 <- a3 <- a4 <- numeric(0)

res <- microbenchmark(a1 <- c(a1, 1),
                      a2 <- append(a2, 1),
                      a3[length(a3) + 1] <- 1,
                      a4[[length(a4) + 1]] <- 1,
                      times=100L)
print(res)
## Change default unit to relative runtime
options(microbenchmark.unit="relative")
print(res)
## Change default unit to evaluations per second
options(microbenchmark.unit="eps")
print(res)

}
\seealso{
\code{\link{boxplot.microbenchmark}} and
\code{\link{autoplot.microbenchmark}} for a plot methods.
}
\author{
Olaf Mersmann
}
