% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8.bivdph.R
\name{MoE,bivdph-method}
\alias{MoE,bivdph-method}
\title{MoE method for bivdph Class}
\usage{
\S4method{MoE}{bivdph}(
  x,
  formula,
  y,
  data,
  alpha_vecs = NULL,
  weight = numeric(0),
  stepsEM = 1000,
  every = 10,
  rand_init = TRUE
)
}
\arguments{
\item{x}{An object of class \linkS4class{bivdph}.}

\item{formula}{A regression formula.}

\item{y}{A matrix of observations.}

\item{data}{A data frame of covariates.}

\item{alpha_vecs}{Matrix of initial probabilities.}

\item{weight}{Vector of weights.}

\item{stepsEM}{Number of EM steps to be performed.}

\item{every}{Number of iterations between likelihood display updates.}

\item{rand_init}{Random initiation in the R-step.}
}
\value{
An object of class \linkS4class{sph}.
}
\description{
MoE method for bivdph Class
}
\examples{
x <- bivdph(dimensions = c(3, 3))
n <- 100
responses <- cbind(rpois(n, 3) + 1, rbinom(n, 5, 0.5))
covariates <- data.frame(age = sample(18:65, n, replace = TRUE) / 100, income = runif(n, 0, 0.99))
f <- responses ~ age + income
MoE(x = x, formula = f, y = responses, data = covariates, stepsEM = 20)
}
