% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_aod.R, R/methods_betareg.R,
%   R/sanity_model.R, R/methods_brms.R, R/methods_glmmTMB.R,
%   R/methods_inferences_simulation.R, R/methods_mclogit.R, R/methods_mlogit.R,
%   R/methods_ordinal.R, R/methods_plm.R, R/methods_quantreg.R
\name{sanitize_model_specific.glimML}
\alias{sanitize_model_specific.glimML}
\alias{sanitize_model_specific.betareg}
\alias{sanitize_model_specific}
\alias{sanitize_model_specific.default}
\alias{sanitize_model_specific.brmsfit}
\alias{sanitize_model_specific.glmmTMB}
\alias{sanitize_model_specific.inferences_simulation}
\alias{sanitize_model_specific.mblogit}
\alias{sanitize_model_specific.mlogit}
\alias{sanitize_model_specific.clm}
\alias{sanitize_model_specific.plm}
\alias{sanitize_model_specific.rqs}
\title{Method to raise model-specific warnings and errors}
\usage{
\method{sanitize_model_specific}{glimML}(model, ...)

\method{sanitize_model_specific}{betareg}(model, ...)

sanitize_model_specific(model, ...)

\method{sanitize_model_specific}{default}(
  model,
  vcov = NULL,
  calling_function = "marginaleffects",
  ...
)

\method{sanitize_model_specific}{brmsfit}(model, ...)

\method{sanitize_model_specific}{glmmTMB}(
  model,
  vcov = NULL,
  calling_function = "marginaleffects",
  ...
)

\method{sanitize_model_specific}{inferences_simulation}(model, vcov = FALSE, ...)

\method{sanitize_model_specific}{mblogit}(model, calling_function = "marginaleffects", ...)

\method{sanitize_model_specific}{mlogit}(model, newdata, ...)

\method{sanitize_model_specific}{clm}(model, ...)

\method{sanitize_model_specific}{plm}(model, ...)

\method{sanitize_model_specific}{plm}(model, ...)

\method{sanitize_model_specific}{rqs}(model, ...)
}
\arguments{
\item{model}{Model object}

\item{...}{Additional arguments are passed to the \code{predict()} method
supplied by the modeling package.These arguments are particularly useful
for mixed-effects or bayesian models (see the online vignettes on the
\code{marginaleffects} website). Available arguments can vary from model to
model, depending on the range of supported arguments by each modeling
package. See the "Model-Specific Arguments" section of the
\code{?marginaleffects} documentation for a non-exhaustive list of available
arguments.}

\item{vcov}{Type of uncertainty estimates to report (e.g., for robust standard errors). Acceptable values:
\itemize{
\item FALSE: Do not compute standard errors. This can speed up computation considerably.
\item TRUE: Unit-level standard errors using the default \code{vcov(model)} variance-covariance matrix.
\item String which indicates the kind of uncertainty estimates to return.
\itemize{
\item Heteroskedasticity-consistent: \code{"HC"}, \code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. See \code{?sandwich::vcovHC}
\item Heteroskedasticity and autocorrelation consistent: \code{"HAC"}
\item Mixed-Models degrees of freedom: "satterthwaite", "kenward-roger"
\item Other: \code{"NeweyWest"}, \code{"KernHAC"}, \code{"OPG"}. See the \code{sandwich} package documentation.
}
\item One-sided formula which indicates the name of cluster variables (e.g., \code{~unit_id}). This formula is passed to the \code{cluster} argument of the \code{sandwich::vcovCL} function.
\item Square covariance matrix
\item Function which returns a covariance matrix (e.g., \code{stats::vcov(model)})
}}

\item{newdata}{Grid of predictor values at which we evaluate the slopes.
\itemize{
\item Warning: Please avoid modifying your dataset between fitting the model and calling a \code{marginaleffects} function. This can sometimes lead to unexpected results.
\item \code{NULL} (default): Unit-level slopes for each observed value in the dataset (empirical distribution). The dataset is retrieved using \code{\link[insight:get_data]{insight::get_data()}}, which tries to extract data from the environment. This may produce unexpected results if the original data frame has been altered since fitting the model.
\item \code{\link[=datagrid]{datagrid()}} call to specify a custom grid of regressors. For example:
\itemize{
\item \code{newdata = datagrid(cyl = c(4, 6))}: \code{cyl} variable equal to 4 and 6 and other regressors fixed at their means or modes.
\item See the Examples section and the \code{\link[=datagrid]{datagrid()}} documentation.
}
\item string:
\itemize{
\item "mean": Marginal Effects at the Mean. Slopes when each predictor is held at its mean or mode.
\item "median": Marginal Effects at the Median. Slopes when each predictor is held at its median or mode.
\item "marginalmeans": Marginal Effects at Marginal Means. See Details section below.
\item "tukey": Marginal Effects at Tukey's 5 numbers.
\item "grid": Marginal Effects on a grid of representative numbers (Tukey's 5 numbers and unique values of categorical predictors).
}
}}
}
\value{
A warning, an error, or nothing
}
\description{
Method to raise model-specific warnings and errors
}
\keyword{internal}
