% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xval.R
\name{lol.xval.split}
\alias{lol.xval.split}
\title{Cross-Validation Data Splitter}
\usage{
lol.xval.split(X, Y, k = "loo", rank.low = FALSE, ...)
}
\arguments{
\item{X}{\code{[n, d]} the data with \code{n} samples in \code{d} dimensions.}

\item{Y}{\code{[n]} the labels of the samples with \code{K} unique labels.}

\item{k}{the cross-validated method to perform. Defaults to \code{'loo'}.
\itemize{
\item{if \code{k == round(k)}, performed k-fold cross-validation.}
\item{if \code{k == 'loo'}, performs leave-one-out cross-validation.}
}}

\item{rank.low}{whether to force the training set to low-rank. Defaults to \code{FALSE}.
\itemize{
\item{if \code{rank == FALSE}, uses default cross-validation method with standard \code{k}-fold validation. Training sets are \code{k-1} folds, and testing sets are \code{1} fold, where the fold held-out for testing is rotated to ensure no dependence of potential downstream inference in the cross-validated misclassification rates.}
\item{if \code{rank == TRUE}, users cross-validation method with \code{ntrain = min((k-1)/k*n, d)} sample training sets, where \code{d}  is the number of dimensions in \code{X}. This ensures that the training data is always low-rank, \code{ntrain < d + 1}. Note that the resulting training sets may have \code{ntrain < (k-1)/k*n}, but the resulting testing sets will always be properly rotated \code{ntest = n/k} to ensure no dependencies in fold-wise testing.}
}}

\item{...}{optional args.}
}
\value{
sets the cross-validation sets as an object of class \code{"XV"} containing the following:
\item{\code{train}}{length \code{[ntrain]} vector indicating the indices of the training examples.}
\item{\code{test}}{ length \code{[ntest]} vector indicating the indices of the testing examples.}
}
\description{
A function to split a dataset into training and testing sets for cross validation. The procedure for cross-validation
is to split the data into k-folds. The k-folds are then rotated individually to form a single held-out testing set the model will be validated on,
and the remaining (k-1) folds are used for training the developed model. Note that this cross-validation function includes functionality to be used for
low-rank cross-validation. In that case, instead of using the full (k-1) folds for training, we subset \code{min((k-1)/k*n, d)} samples to ensure that
the resulting training sets  are all low-rank. We still rotate properly over the held-out fold to ensure that the resulting testing sets
do not have any shared examples, which would add a complicated  dependence structure to inference we attempt to infer on the testing sets.
}
\examples{
# prepare data for 10-fold validation
library(lolR)
data <- lol.sims.rtrunk(n=200, d=30)  # 200 examples of 30 dimensions
X <- data$X; Y <- data$Y
sets.xval.10fold <- lol.xval.split(X, Y, k=10)

# prepare data for loo validation
sets.xval.loo <- lol.xval.split(X, Y, k='loo')

}
\author{
Eric Bridgeford
}
