library(tidyverse)

# Colors for the `opt_stylize()` function; there are five levels of colors
# increasing from very light (90-96% lightness) to darker (0-30% lightness)
# All color combinations (computed text color with background color from the
# below matrix) were checked against the WebAIM Contrast Checker tool (at
# https://webaim.org/resources/contrastchecker, requiring a WCAG AA passing
# grade) and the Chrome Dev Tools accessibility indicator for contrast
# (requiring a passing checkmark)

# TODO: Develop a solution for auto-checking contrast in every cell (every
# combination of text and background color); might involve using an API (where
# the rendered document is posted).

preset_colors <-
  list(
    gray =    c("#F4F4F4", "#D5D5D5", "#929292", "#5F5F5F", "#000000"),
    blue =    c("#EDF7FC", "#89D3FE", "#00A1FF", "#0076BA", "#004D80"),
    cyan =    c("#EBFBF9", "#A5FEF2", "#7FE9DB", "#01837B", "#016763"),
    pink =    c("#FCF2F7", "#FFC6E3", "#EF5FA7", "#CB2A7B", "#99195F"),
    green =   c("#EDF6E8", "#CAFFAF", "#89FD61", "#038901", "#027101"),
    red =     c("#FEEDEC", "#FFCCC7", "#FF644E", "#E4220C", "#A81600")
  )

# Function for getting a vector of preset colors at a specified 'level'
get_all_preset_colors_at_index <- function(index) {

  preset_colors %>%
    vapply(
      FUN.VALUE = character(1L),
      USE.NAMES = FALSE,
      FUN = function(x) x[[index]]
    )
}

# Create a tibble that contains all style and color parameters for the
# themed tables generated by the `opt_stylize()` function
styles_colors_params <-
  dplyr::tibble() %>%
  dplyr::bind_rows(
    dplyr::tibble( # style 1
      color = names(preset_colors),
      style = 1,
      table_hlines_color = get_all_preset_colors_at_index(5),
      location_hlines_color = get_all_preset_colors_at_index(4),
      column_labels_background_color = "#FFFFFF",
      stub_background_color = get_all_preset_colors_at_index(4),
      stub_border_style = "solid",
      stub_border_color = get_all_preset_colors_at_index(4),
      data_hlines_style = "none",
      data_hlines_color = get_all_preset_colors_at_index(2),
      data_vlines_style = "none",
      data_vlines_color = get_all_preset_colors_at_index(2),
      summary_row_background_color = "#FFFFFF",
      grand_summary_row_background_color = get_all_preset_colors_at_index(2),
      row_striping_background_color = preset_colors$gray[[1]],
      table_outline_color = NA_character_
    )
  ) %>%
  dplyr::bind_rows(
    dplyr::tibble( # style 2
      color = names(preset_colors),
      style = 2,
      table_hlines_color = preset_colors$gray[[2]],
      location_hlines_color = preset_colors$gray[[2]],
      column_labels_background_color = get_all_preset_colors_at_index(5),
      stub_background_color = "#FFFFFF",
      stub_border_style = "solid",
      stub_border_color = preset_colors$gray[[4]],
      data_hlines_style = "solid",
      data_hlines_color = get_all_preset_colors_at_index(2),
      data_vlines_style = "solid",
      data_vlines_color = get_all_preset_colors_at_index(2),
      summary_row_background_color = get_all_preset_colors_at_index(2),
      grand_summary_row_background_color = get_all_preset_colors_at_index(3),
      row_striping_background_color = preset_colors$gray[[1]],
      table_outline_color = preset_colors$gray[[2]]
    )
  ) %>%
  dplyr::bind_rows(
    dplyr::tibble( # style 3
      color = names(preset_colors),
      style = 3,
      table_hlines_color = preset_colors$gray[[3]],
      location_hlines_color = preset_colors$gray[[3]],
      column_labels_background_color = get_all_preset_colors_at_index(5),
      stub_background_color = preset_colors$gray[[2]],
      stub_border_style = "none",
      stub_border_color = "#FFFFFF",
      data_hlines_style = "dashed",
      data_hlines_color = preset_colors$gray[[3]],
      data_vlines_style = "none",
      data_vlines_color = preset_colors$gray[[3]],
      summary_row_background_color = "#FFFFFF",
      grand_summary_row_background_color = preset_colors$gray[[2]],
      row_striping_background_color = preset_colors$gray[[1]],
      table_outline_color = NA_character_
    )
  ) %>%
  dplyr::bind_rows(
    dplyr::tibble( # style 4
      color = names(preset_colors),
      style = 4,
      table_hlines_color = preset_colors$gray[[2]],
      location_hlines_color = preset_colors$gray[[2]],
      column_labels_background_color = get_all_preset_colors_at_index(4),
      stub_background_color = preset_colors$gray[[3]],
      stub_border_style = "dashed",
      stub_border_color = preset_colors$gray[[2]],
      data_hlines_style = "dashed",
      data_hlines_color = preset_colors$gray[[2]],
      data_vlines_style = "dashed",
      data_vlines_color = preset_colors$gray[[2]],
      summary_row_background_color = "#FFFFFF",
      grand_summary_row_background_color = get_all_preset_colors_at_index(4),
      row_striping_background_color = preset_colors$gray[[1]],
      table_outline_color = preset_colors$gray[[2]]
    )
  ) %>%
  dplyr::bind_rows(
    dplyr::tibble( # style 5
      color = names(preset_colors),
      style = 5,
      table_hlines_color = preset_colors$gray[[2]],
      location_hlines_color = preset_colors$gray[[2]],
      column_labels_background_color = get_all_preset_colors_at_index(5),
      stub_background_color = preset_colors$gray[[3]],
      stub_border_style = "solid",
      stub_border_color = preset_colors$gray[[2]],
      data_hlines_style = "solid",
      data_hlines_color = preset_colors$gray[[2]],
      data_vlines_style = "solid",
      data_vlines_color = preset_colors$gray[[2]],
      summary_row_background_color = preset_colors$gray[[4]],
      grand_summary_row_background_color = preset_colors$gray[[3]],
      row_striping_background_color = preset_colors$gray[[1]],
      table_outline_color = preset_colors$gray[[2]]
    )
  ) %>%
  dplyr::bind_rows(
    dplyr::tibble( # style 6
      color = names(preset_colors),
      style = 6,
      table_hlines_color = preset_colors$gray[[4]],
      location_hlines_color = preset_colors$gray[[4]],
      column_labels_background_color = get_all_preset_colors_at_index(4),
      stub_background_color = get_all_preset_colors_at_index(2),
      stub_border_style = "solid",
      stub_border_color = preset_colors$gray[[2]],
      data_hlines_style = "none",
      data_hlines_color = preset_colors$gray[[2]],
      data_vlines_style = "none",
      data_vlines_color = preset_colors$gray[[2]],
      summary_row_background_color = "#FFFFFF",
      grand_summary_row_background_color = preset_colors$gray[[2]],
      row_striping_background_color = get_all_preset_colors_at_index(1),
      table_outline_color = NA_character_
    )
  )
