library(tidyverse)

css_colors <-
  dplyr::tribble(
    ~color_name, ~hexadecimal, ~category,
    "IndianRed", "#CD5C5C", "Reds",
    "LightCoral", "#F08080", "Reds",
    "Salmon", "#FA8072", "Reds",
    "DarkSalmon", "#E9967A", "Reds",
    "LightSalmon", "#FFA07A", "Reds",
    "Crimson", "#DC143C", "Reds",
    "Red", "#FF0000", "Reds",
    "FireBrick", "#B22222", "Reds",
    "DarkRed", "#8B0000", "Reds",
    "Pink", "#FFC0CB", "Pinks",
    "LightPink", "#FFB6C1", "Pinks",
    "HotPink", "#FF69B4", "Pinks",
    "DeepPink", "#FF1493", "Pinks",
    "MediumVioletRed", "#C71585", "Pinks",
    "PaleVioletRed", "#DB7093", "Pinks",
    "Coral", "#FF7F50", "Oranges",
    "Tomato", "#FF6347", "Oranges",
    "OrangeRed", "#FF4500", "Oranges",
    "DarkOrange", "#FF8C00", "Oranges",
    "Orange", "#FFA500", "Oranges",
    "Gold", "#FFD700", "Yellows",
    "Yellow", "#FFFF00", "Yellows",
    "LightYellow", "#FFFFE0", "Yellows",
    "LemonChiffon", "#FFFACD", "Yellows",
    "LightGoldenrodYellow", "#FAFAD2", "Yellows",
    "PapayaWhip", "#FFEFD5", "Yellows",
    "Moccasin", "#FFE4B5", "Yellows",
    "PeachPuff", "#FFDAB9", "Yellows",
    "PaleGoldenrod", "#EEE8AA", "Yellows",
    "Khaki", "#F0E68C", "Yellows",
    "DarkKhaki", "#BDB76B", "Yellows",
    "Lavender", "#E6E6FA", "Purples",
    "Thistle", "#D8BFD8", "Purples",
    "Plum", "#DDA0DD", "Purples",
    "Violet", "#EE82EE", "Purples",
    "Orchid", "#DA70D6", "Purples",
    "Fuchsia", "#FF00FF", "Purples",
    "Magenta", "#FF00FF", "Purples",
    "MediumOrchid", "#BA55D3", "Purples",
    "MediumPurple", "#9370DB", "Purples",
    "BlueViolet", "#8A2BE2", "Purples",
    "DarkViolet", "#9400D3", "Purples",
    "DarkOrchid", "#9932CC", "Purples",
    "DarkMagenta", "#8B008B", "Purples",
    "Purple", "#800080", "Purples",
    "RebeccaPurple", "#663399", "Purples",
    "Indigo", "#4B0082", "Purples",
    "MediumSlateBlue", "#7B68EE", "Purples",
    "SlateBlue", "#6A5ACD", "Purples",
    "DarkSlateBlue", "#483D8B", "Purples",
    "GreenYellow", "#ADFF2F", "Greens",
    "Chartreuse", "#7FFF00", "Greens",
    "LawnGreen", "#7CFC00", "Greens",
    "Lime", "#00FF00", "Greens",
    "LimeGreen", "#32CD32", "Greens",
    "PaleGreen", "#98FB98", "Greens",
    "LightGreen", "#90EE90", "Greens",
    "MediumSpringGreen", "#00FA9A", "Greens",
    "SpringGreen", "#00FF7F", "Greens",
    "MediumSeaGreen", "#3CB371", "Greens",
    "SeaGreen", "#2E8B57", "Greens",
    "ForestGreen", "#228B22", "Greens",
    "Green", "#008000", "Greens",
    "DarkGreen", "#006400", "Greens",
    "YellowGreen", "#9ACD32", "Greens",
    "OliveDrab", "#6B8E23", "Greens",
    "Olive", "#808000", "Greens",
    "DarkOliveGreen", "#556B2F", "Greens",
    "MediumAquamarine", "#66CDAA", "Greens",
    "DarkSeaGreen", "#8FBC8F", "Greens",
    "LightSeaGreen", "#20B2AA", "Greens",
    "DarkCyan", "#008B8B", "Greens",
    "Teal", "#008080", "Greens",
    "Aqua", "#00FFFF", "Blues/Cyans",
    "Cyan", "#00FFFF", "Blues/Cyans",
    "LightCyan", "#E0FFFF", "Blues/Cyans",
    "PaleTurquoise", "#AFEEEE", "Blues/Cyans",
    "Aquamarine", "#7FFFD4", "Blues/Cyans",
    "Turquoise", "#40E0D0", "Blues/Cyans",
    "MediumTurquoise", "#48D1CC", "Blues/Cyans",
    "DarkTurquoise", "#00CED1", "Blues/Cyans",
    "CadetBlue", "#5F9EA0", "Blues/Cyans",
    "SteelBlue", "#4682B4", "Blues/Cyans",
    "LightSteelBlue", "#B0C4DE", "Blues/Cyans",
    "PowderBlue", "#B0E0E6", "Blues/Cyans",
    "LightBlue", "#ADD8E6", "Blues/Cyans",
    "SkyBlue", "#87CEEB", "Blues/Cyans",
    "LightSkyBlue", "#87CEFA", "Blues/Cyans",
    "DeepSkyBlue", "#00BFFF", "Blues/Cyans",
    "DodgerBlue", "#1E90FF", "Blues/Cyans",
    "CornflowerBlue", "#6495ED", "Blues/Cyans",
    "RoyalBlue", "#4169E1", "Blues/Cyans",
    "Blue", "#0000FF", "Blues/Cyans",
    "MediumBlue", "#0000CD", "Blues/Cyans",
    "DarkBlue", "#00008B", "Blues/Cyans",
    "Navy", "#000080", "Blues/Cyans",
    "MidnightBlue", "#191970", "Blues/Cyans",
    "Cornsilk", "#FFF8DC", "Browns",
    "BlanchedAlmond", "#FFEBCD", "Browns",
    "Bisque", "#FFE4C4", "Browns",
    "NavajoWhite", "#FFDEAD", "Browns",
    "Wheat", "#F5DEB3", "Browns",
    "BurlyWood", "#DEB887", "Browns",
    "Tan", "#D2B48C", "Browns",
    "RosyBrown", "#BC8F8F", "Browns",
    "SandyBrown", "#F4A460", "Browns",
    "Goldenrod", "#DAA520", "Browns",
    "DarkGoldenrod", "#B8860B", "Browns",
    "Peru", "#CD853F", "Browns",
    "Chocolate", "#D2691E", "Browns",
    "SaddleBrown", "#8B4513", "Browns",
    "Sienna", "#A0522D", "Browns",
    "Brown", "#A52A2A", "Browns",
    "Maroon", "#800000", "Browns",
    "White", "#FFFFFF", "Whites",
    "Snow", "#FFFAFA", "Whites",
    "Honeydew", "#F0FFF0", "Whites",
    "MintCream", "#F5FFFA", "Whites",
    "Azure", "#F0FFFF", "Whites",
    "AliceBlue", "#F0F8FF", "Whites",
    "GhostWhite", "#F8F8FF", "Whites",
    "WhiteSmoke", "#F5F5F5", "Whites",
    "Seashell", "#FFF5EE", "Whites",
    "Beige", "#F5F5DC", "Whites",
    "OldLace", "#FDF5E6", "Whites",
    "FloralWhite", "#FFFAF0", "Whites",
    "Ivory", "#FFFFF0", "Whites",
    "AntiqueWhite", "#FAEBD7", "Whites",
    "Linen", "#FAF0E6", "Whites",
    "LavenderBlush", "#FFF0F5", "Whites",
    "MistyRose", "#FFE4E1", "Whites",
    "Gainsboro", "#DCDCDC", "Greys",
    "LightGray", "#D3D3D3", "Greys",
    "LightGrey", "#D3D3D3", "Greys",
    "Silver", "#C0C0C0", "Greys",
    "DarkGray", "#A9A9A9", "Greys",
    "DarkGrey", "#A9A9A9", "Greys",
    "Gray", "#808080", "Greys",
    "Grey", "#808080", "Greys",
    "DimGray", "#696969", "Greys",
    "DimGrey", "#696969", "Greys",
    "LightSlateGray", "#778899", "Greys",
    "LightSlateGrey", "#778899", "Greys",
    "SlateGray", "#708090", "Greys",
    "SlateGrey", "#708090", "Greys",
    "DarkSlateGray", "#2F4F4F", "Greys",
    "DarkSlateGrey", "#2F4F4F", "Greys",
    "Black", "#000000", "Greys"
  ) %>%
  dplyr::mutate(
    is_x11_color = ifelse(
      tolower(color_name) %in% grDevices::colors(), TRUE, FALSE
    )
  )
